/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.core.util;

import dev.kosmx.playerAnim.core.util.Easing;
import java.util.function.Function;

public enum Ease {
    LINEAR(0, arg -> Ease.easeIn(f -> f)),
    CONSTANT(1, arg -> Ease.easeIn(f -> Float.valueOf(0.0f))),
    INSINE(6, arg -> Ease.easeIn(Easing::sine)),
    OUTSINE(7, arg -> Ease.easeOut(Easing::sine)),
    INOUTSINE(8, arg -> Ease.easeInOut(Easing::sine)),
    INCUBIC(9, arg -> Ease.easeIn(Easing::cubic)),
    OUTCUBIC(10, arg -> Ease.easeOut(Easing::cubic)),
    INOUTCUBIC(11, arg -> Ease.easeInOut(Easing::cubic)),
    INQUAD(12, arg -> Ease.easeIn(Easing::quadratic)),
    OUTQUAD(13, arg -> Ease.easeOut(Easing::quadratic)),
    INOUTQUAD(14, arg -> Ease.easeInOut(Easing::quadratic)),
    INQUART(15, arg -> Ease.easeIn(Easing.pow(4.0f))),
    OUTQUART(16, arg -> Ease.easeOut(Easing.pow(4.0f))),
    INOUTQUART(17, arg -> Ease.easeInOut(Easing.pow(4.0f))),
    INQUINT(18, arg -> Ease.easeIn(Easing.pow(5.0f))),
    OUTQUINT(19, arg -> Ease.easeOut(Easing.pow(5.0f))),
    INOUTQUINT(20, arg -> Ease.easeInOut(Easing.pow(5.0f))),
    INEXPO(21, arg -> Ease.easeIn(Easing::exp)),
    OUTEXPO(22, arg -> Ease.easeOut(Easing::exp)),
    INOUTEXPO(23, arg -> Ease.easeInOut(Easing::exp)),
    INCIRC(24, arg -> Ease.easeIn(Easing::circle)),
    OUTCIRC(25, arg -> Ease.easeOut(Easing::circle)),
    INOUTCIRC(26, arg -> Ease.easeInOut(Easing::circle)),
    INBACK(27, arg -> Ease.easeIn(Easing.back(arg))),
    OUTBACK(28, arg -> Ease.easeOut(Easing.back(arg))),
    INOUTBACK(29, arg -> Ease.easeInOut(Easing.back(arg))),
    INELASTIC(30, arg -> Ease.easeIn(Easing.elastic(arg))),
    OUTELASTIC(31, arg -> Ease.easeOut(Easing.elastic(arg))),
    INOUTELASTIC(32, arg -> Ease.easeInOut(Easing.elastic(arg))),
    INBOUNCE(33, arg -> Ease.easeIn(Easing.bounce(arg))),
    OUTBOUNCE(34, arg -> Ease.easeOut(Easing.bounce(arg))),
    INOUTBOUNCE(35, arg -> Ease.easeInOut(Easing.bounce(arg))),
    CATMULLROM(36, arg -> Ease.easeInOut(Easing::catmullRom)),
    STEP(37, arg -> Ease.easeIn(Easing.step(arg)));

    final byte id;
    private final Function<Float, Function<Float, Float>> impl;

    private Ease(byte id, Function<Float, Function<Float, Float>> impl) {
        this.id = id;
        this.impl = impl;
    }

    private Ease(int id, Function<Float, Function<Float, Float>> impl) {
        this((byte)id, impl);
    }

    public float invoke(float f) {
        return this.invoke(f, null);
    }

    public float invoke(float t, Float n) {
        return this.impl.apply(n).apply(Float.valueOf(t)).floatValue();
    }

    public static Ease getEase(byte b) {
        for (Ease ease : Ease.values()) {
            if (ease.id != b) continue;
            return ease;
        }
        return LINEAR;
    }

    public static Function<Float, Float> easeIn(Function<Float, Float> function) {
        return function;
    }

    public static Function<Float, Float> easeOut(Function<Float, Float> function) {
        return time -> Float.valueOf(1.0f - ((Float)function.apply(Float.valueOf(1.0f - time.floatValue()))).floatValue());
    }

    public static Function<Float, Float> easeInOut(Function<Float, Float> function) {
        return time -> {
            if (time.floatValue() < 0.5f) {
                return Float.valueOf(((Float)function.apply(Float.valueOf(time.floatValue() * 2.0f))).floatValue() / 2.0f);
            }
            return Float.valueOf(1.0f - ((Float)function.apply(Float.valueOf((1.0f - time.floatValue()) * 2.0f))).floatValue() / 2.0f);
        };
    }

    public byte getId() {
        return this.id;
    }
}

