/*
 * Decompiled with CFR 0.152.
 */
package net.wizards.content;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.spell_engine.api.datagen.SpellBuilder;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_power.api.SpellSchools;
import net.wizards.content.WizardsSounds;
import net.wizards.effect.WizardsEffects;
import org.jetbrains.annotations.Nullable;

public class WizardSpells {
    public static final List<Entry> entries = new ArrayList<Entry>();
    private static final String PRIMARY_GROUP = "primary";
    private static final float BASIC_PROJECTILE_RANGE = 48.0f;
    private static final Color ARCANE_COLOR = Color.from((int)SpellSchools.ARCANE.color);
    private static final Color FIRE_COLOR = Color.from((int)SpellSchools.FIRE.color);
    private static final Color FROST_COLOR = Color.from((int)SpellSchools.FROST.color);
    public static Entry arcane_bolt = WizardSpells.add(WizardSpells.arcane_bolt());
    public static Entry arcane_blast = WizardSpells.add(WizardSpells.arcane_blast());
    public static Entry arcane_missile = WizardSpells.add(WizardSpells.arcane_missile());
    public static Entry arcane_beam = WizardSpells.add(WizardSpells.arcane_beam());
    public static Entry arcane_blink = WizardSpells.add(WizardSpells.arcane_blink());
    public static Entry fire_scorch = WizardSpells.add(WizardSpells.fire_scorch());
    public static Entry fireball = WizardSpells.add(WizardSpells.fireball());
    public static Entry fire_blast = WizardSpells.add(WizardSpells.fire_blast());
    public static Entry fire_breath = WizardSpells.add(WizardSpells.fire_breath());
    public static Entry fire_meteor = WizardSpells.add(WizardSpells.fire_meteor());
    public static Entry fire_wall = WizardSpells.add(WizardSpells.fire_wall());
    public static Entry frost_shard = WizardSpells.add(WizardSpells.frost_shard());
    public static Entry frostbolt = WizardSpells.add(WizardSpells.frostbolt());
    public static Entry frost_nova = WizardSpells.add(WizardSpells.frost_nova());
    public static Entry frost_shield = WizardSpells.add(WizardSpells.frost_shield());
    public static Entry frost_blizzard = WizardSpells.add(WizardSpells.frost_blizzard());

    private static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Spell activeSpellBase() {
        Spell spell = new Spell();
        spell.type = Spell.Type.ACTIVE;
        spell.active = new Spell.Active();
        spell.active.cast = new Spell.Active.Cast();
        return spell;
    }

    private static ParticleBatch arcaneCastingParticles() {
        return new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.1f).color(ARCANE_COLOR.toRGBA());
    }

    private static void configureArcaneRuneCost(Spell spell) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.item = new Spell.Cost.Item();
        spell.cost.item.id = "runes:arcane_stone";
    }

    private static void configureCooldown(Spell spell, float duration) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.cooldown = new Spell.Cost.Cooldown();
        spell.cost.cooldown.duration = duration;
    }

    private static ParticleBatch fireCastingParticles() {
        return new ParticleBatch(SpellEngineParticles.flame.id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.1f);
    }

    private static void configureFireRuneCost(Spell spell) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.item = new Spell.Cost.Item();
        spell.cost.item.id = "runes:fire_stone";
    }

    private static ParticleBatch[] fireImpactParticles() {
        return new ParticleBatch[]{new ParticleBatch("smoke", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.01f, 0.1f), new ParticleBatch("flame", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 10.0f, 0.01f, 0.1f)};
    }

    private static ParticleBatch frostCastingParticles() {
        return new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.CENTER, 0.5f, 0.1f, 0.2f);
    }

    private static void configureFrostRuneCost(Spell spell) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.item = new Spell.Cost.Item();
        spell.cost.item.id = "runes:frost_stone";
    }

    private static ParticleBatch[] frostImpactParticles() {
        return new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.FROST, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 50.0f, 0.2f, 0.7f).color(FROST_COLOR.toRGBA())};
    }

    private static Entry arcane_bolt() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"arcane_bolt");
        Spell spell = WizardSpells.activeSpellBase();
        spell.school = SpellSchools.ARCANE;
        spell.group = PRIMARY_GROUP;
        spell.tier = 0;
        spell.range = 48.0f;
        spell.active.cast.duration = 1.0f;
        spell.active.cast.animation = "spell_engine:one_handed_projectile_charge";
        spell.active.cast.sound = new Sound(SpellEngineSounds.GENERIC_ARCANE_CASTING.id(), 0.0f);
        spell.active.cast.particles = new ParticleBatch[]{WizardSpells.arcaneCastingParticles()};
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_projectile_release";
        spell.release.sound = new Sound(WizardsSounds.ARCANE_MISSILE_RELEASE.id());
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.deliver.type = Spell.Delivery.Type.PROJECTILE;
        spell.deliver.projectile = new Spell.Delivery.ShootProjectile();
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.homing_angle = 1.0f;
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.light_level = 10;
        projectile.client_data.travel_particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 1.0f, 0.05f, 0.1f, 0.0f, 0.0f).color(ARCANE_COLOR.toRGBA())};
        projectile.client_data.model = new Spell.ProjectileModel();
        projectile.client_data.model.model_id = "wizards:projectile/arcane_bolt";
        projectile.client_data.model.scale = 0.5f;
        spell.deliver.projectile.projectile = projectile;
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.7f, (float)0.6f);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.ARCANE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 20.0f, 0.2f, 0.7f, 0.0f, 0.0f).color(ARCANE_COLOR.toRGBA())};
        damage.sound = new Sound(WizardsSounds.ARCANE_MISSILE_IMPACT.id());
        spell.impacts = List.of(damage);
        WizardSpells.configureArcaneRuneCost(spell);
        return new Entry(id, spell, "", "", null);
    }

    private static Entry arcane_blast() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"arcane_blast");
        Spell spell = SpellBuilder.createSpellActive();
        spell.school = SpellSchools.ARCANE;
        spell.group = PRIMARY_GROUP;
        spell.tier = 1;
        spell.sub_tier = 2;
        spell.range = 16.0f;
        spell.learn = new Spell.Learn();
        spell.active.scroll = new Spell.Active.Scroll();
        spell.active.cast.duration = 1.5f;
        spell.active.cast.animation = "spell_engine:one_handed_projectile_charge";
        spell.active.cast.sound = new Sound(SpellEngineSounds.GENERIC_ARCANE_CASTING.id(), 0.0f);
        spell.active.cast.particles = new ParticleBatch[]{WizardSpells.arcaneCastingParticles()};
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_projectile_release";
        spell.release.sound = new Sound(WizardsSounds.ARCANE_MISSILE_RELEASE.id());
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.sticky = true;
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.8f, (float)0.5f);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.ARCANE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 30.0f, 0.2f, 0.7f).color(ARCANE_COLOR.toRGBA()), new ParticleBatch("firework", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 20.0f, 0.05f, 0.2f)};
        damage.sound = new Sound(WizardsSounds.ARCANE_BLAST_IMPACT.id());
        Spell.Impact arcaneCharge = SpellBuilder.Impacts.effectAdd((String)WizardsEffects.arcaneCharge.id.toString(), (float)10.0f, (int)1, (int)2);
        arcaneCharge.action.status_effect.show_particles = false;
        arcaneCharge.action.apply_to_caster = true;
        spell.impacts = List.of(damage, arcaneCharge);
        WizardSpells.configureArcaneRuneCost(spell);
        return new Entry(id, spell, "", "", null);
    }

    private static Entry arcane_missile() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"arcane_missile");
        Spell spell = SpellBuilder.createSpellActive();
        spell.school = SpellSchools.ARCANE;
        spell.tier = 2;
        spell.range = 64.0f;
        spell.learn = new Spell.Learn();
        spell.active.scroll = new Spell.Active.Scroll();
        SpellBuilder.Casting.channel((Spell)spell, (float)4.0f, (int)6);
        spell.active.cast.animation = "spell_engine:two_handed_channeling";
        spell.active.cast.sound = new Sound(SpellEngineSounds.GENERIC_ARCANE_CASTING.id(), 0.0f);
        spell.active.cast.particles = new ParticleBatch[]{WizardSpells.arcaneCastingParticles()};
        spell.release = new Spell.Release();
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.sticky = true;
        spell.deliver.type = Spell.Delivery.Type.PROJECTILE;
        spell.deliver.projectile = new Spell.Delivery.ShootProjectile();
        spell.deliver.projectile.direction_offsets_require_target = true;
        spell.deliver.projectile.direction_offsets = new Spell.Delivery.ShootProjectile.DirectionOffset[]{new Spell.Delivery.ShootProjectile.DirectionOffset(15.0f, 0.0f), new Spell.Delivery.ShootProjectile.DirectionOffset(0.0f, -15.0f), new Spell.Delivery.ShootProjectile.DirectionOffset(-15.0f, 0.0f)};
        spell.deliver.projectile.launch_properties.velocity = 1.25f;
        spell.deliver.projectile.launch_properties.sound = new Sound(WizardsSounds.ARCANE_MISSILE_RELEASE.id());
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.homing_angle = 4.0f;
        projectile.homing_angles = new float[]{60.0f, 30.0f, 15.0f};
        projectile.homing_after_absolute_distance = 8.0f;
        projectile.homing_after_relative_distance = 0.3f;
        projectile.perks.pierce = 2;
        projectile.perks.bounce = 1;
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.light_level = 12;
        projectile.client_data.travel_particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 2.0f, 0.05f, 0.1f, 0.0f).color(ARCANE_COLOR.toRGBA())};
        projectile.client_data.model = new Spell.ProjectileModel();
        projectile.client_data.model.model_id = "wizards:projectile/arcane_missile";
        projectile.client_data.model.scale = 0.6f;
        spell.deliver.projectile.projectile = projectile;
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.8f, (float)0.5f);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.ARCANE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 40.0f, 0.2f, 0.7f).color(ARCANE_COLOR.toRGBA())};
        damage.sound = new Sound(WizardsSounds.ARCANE_MISSILE_IMPACT.id());
        spell.impacts = List.of(damage);
        WizardSpells.configureArcaneRuneCost(spell);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)2.0f);
        spell.cost.cooldown.proportional = true;
        return new Entry(id, spell, "", "", null);
    }

    private static Entry arcane_beam() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"arcane_beam");
        Spell spell = SpellBuilder.createSpellActive();
        spell.school = SpellSchools.ARCANE;
        spell.tier = 3;
        spell.range = 32.0f;
        spell.learn = new Spell.Learn();
        spell.active.scroll = new Spell.Active.Scroll();
        SpellBuilder.Casting.channel((Spell)spell, (float)5.0f, (int)4);
        spell.active.cast.animation = "spell_engine:two_handed_channeling";
        spell.active.cast.sound = new Sound(WizardsSounds.ARCANE_BEAM_CASTING.id(), 0.0f);
        spell.active.cast.start_sound = new Sound(WizardsSounds.ARCANE_BEAM_START.id());
        spell.active.cast.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.PIPE, ParticleBatch.Origin.LAUNCH_POINT, ParticleBatch.Rotation.LOOK, 0.5f, 0.1f, 0.2f, 0.0f).color(ARCANE_COLOR.toRGBA()), new ParticleBatch("firework", ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.LAUNCH_POINT, ParticleBatch.Rotation.LOOK, 0.5f, 0.1f, 0.2f, 0.0f)};
        spell.release = new Spell.Release();
        spell.release.sound = new Sound(WizardsSounds.ARCANE_BEAM_RELEASE.id());
        spell.target.type = Spell.Target.Type.BEAM;
        spell.target.beam = new Spell.Target.Beam();
        spell.target.beam.color_rgba = 0xFF66FFFFL;
        spell.target.beam.width = 0.08f;
        spell.target.beam.flow = 1.5f;
        spell.target.beam.block_hit_particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 1.0f, 0.1f, 0.2f, 0.0f).color(ARCANE_COLOR.toRGBA()), new ParticleBatch("firework", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 1.0f, 0.1f, 0.2f, 0.0f), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.ARCANE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 3.0f, 0.3f, 0.4f).color(ARCANE_COLOR.toRGBA())};
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)1.0f, (float)1.0f);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.ARCANE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 4.0f, 0.2f, 0.7f).color(ARCANE_COLOR.toRGBA()), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.SPELL, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.ASCEND).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 2.0f, 0.1f, 0.2f).color(ARCANE_COLOR.toRGBA()), new ParticleBatch("firework", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 3.0f, 0.1f, 0.2f)};
        damage.sound = new Sound(WizardsSounds.ARCANE_BEAM_IMPACT.id());
        spell.impacts = List.of(damage);
        SpellBuilder.Cost.exhaust((Spell)spell, (float)0.3f);
        spell.cost.effect_id = WizardsEffects.arcaneCharge.id.toString();
        WizardSpells.configureArcaneRuneCost(spell);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)10.0f);
        spell.cost.cooldown.proportional = true;
        return new Entry(id, spell, "", "", null);
    }

    private static Entry arcane_blink() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"arcane_blink");
        Spell spell = SpellBuilder.createSpellActive();
        spell.school = SpellSchools.ARCANE;
        spell.tier = 4;
        spell.range = 0.0f;
        spell.learn = new Spell.Learn();
        spell.active.scroll = new Spell.Active.Scroll();
        SpellBuilder.Casting.instant((Spell)spell);
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_area_release";
        spell.release.sound = new Sound(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"entity.enderman.teleport"));
        Spell.Impact teleport = new Spell.Impact();
        teleport.action = new Spell.Impact.Action();
        teleport.action.type = Spell.Impact.Action.Type.TELEPORT;
        teleport.action.teleport = new Spell.Impact.Action.Teleport();
        teleport.action.teleport.mode = Spell.Impact.Action.Teleport.Mode.FORWARD;
        teleport.action.teleport.forward = new Spell.Impact.Action.Teleport.Forward();
        teleport.action.teleport.forward.distance = 15.0f;
        teleport.action.teleport.depart_particles = new ParticleBatch[]{new ParticleBatch("minecraft:portal", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 40.0f, 0.1f, 0.3f).preSpawnTravel(1.0f)};
        teleport.particles = new ParticleBatch[]{new ParticleBatch("minecraft:portal", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 40.0f, 0.1f, 0.3f).invert().preSpawnTravel(4.0f)};
        spell.impacts = List.of(teleport);
        SpellBuilder.Cost.exhaust((Spell)spell, (float)0.4f);
        WizardSpells.configureArcaneRuneCost(spell);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)12.0f);
        return new Entry(id, spell, "", "", null);
    }

    private static Entry fire_scorch() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"fire_scorch");
        Spell spell = SpellBuilder.createSpellActive();
        spell.school = SpellSchools.FIRE;
        spell.group = PRIMARY_GROUP;
        spell.tier = 0;
        spell.sub_tier = 0;
        spell.range = 16.0f;
        spell.active.cast.duration = 1.2f;
        spell.active.cast.animation = "spell_engine:one_handed_projectile_charge";
        spell.active.cast.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_CASTING.id(), 0.0f);
        spell.active.cast.particles = new ParticleBatch[]{WizardSpells.fireCastingParticles()};
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_projectile_release";
        spell.release.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_RELEASE.id());
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.required = true;
        spell.target.aim.sticky = true;
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.6f, (float)0.6f);
        damage.particles = WizardSpells.fireImpactParticles();
        damage.sound = new Sound(WizardsSounds.FIRE_SCORCH_IMPACT.id());
        Spell.Impact fire = SpellBuilder.Impacts.fire((float)3.0f);
        spell.impacts = List.of(damage, fire);
        WizardSpells.configureFireRuneCost(spell);
        return new Entry(id, spell, "", "", null);
    }

    private static Entry fireball() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"fireball");
        Spell spell = SpellBuilder.createSpellActive();
        spell.school = SpellSchools.FIRE;
        spell.group = PRIMARY_GROUP;
        spell.tier = 0;
        spell.range = 64.0f;
        spell.learn = new Spell.Learn();
        spell.active.scroll = new Spell.Active.Scroll();
        spell.active.cast.duration = 1.5f;
        spell.active.cast.animation = "spell_engine:one_handed_projectile_charge";
        spell.active.cast.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_CASTING.id(), 0.0f);
        spell.active.cast.particles = new ParticleBatch[]{WizardSpells.fireCastingParticles()};
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_projectile_release";
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.deliver.type = Spell.Delivery.Type.PROJECTILE;
        spell.deliver.projectile = new Spell.Delivery.ShootProjectile();
        spell.deliver.projectile.launch_properties.velocity = 1.0f;
        spell.deliver.projectile.launch_properties.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_RELEASE.id());
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.homing_angle = 1.0f;
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.light_level = 12;
        projectile.client_data.travel_particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 3.0f, 0.0f, 0.1f, 0.0f), new ParticleBatch("smoke", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 1.0f, 0.0f, 0.1f, 0.0f)};
        projectile.client_data.model = new Spell.ProjectileModel();
        projectile.client_data.model.model_id = "wizards:projectile/fireball";
        projectile.client_data.model.scale = 0.5f;
        spell.deliver.projectile.projectile = projectile;
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.8f, (float)0.8f);
        damage.particles = new ParticleBatch[]{new ParticleBatch("smoke", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.01f, 0.1f), new ParticleBatch(SpellEngineParticles.flame_medium_b.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 15.0f, 0.1f, 0.2f)};
        damage.sound = new Sound(WizardsSounds.FIRE_SCORCH_IMPACT.id());
        Spell.Impact fire = SpellBuilder.Impacts.fire((float)4.0f);
        spell.impacts = List.of(damage, fire);
        WizardSpells.configureFireRuneCost(spell);
        return new Entry(id, spell, "", "", null);
    }

    private static Entry fire_blast() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"fire_blast");
        Spell spell = SpellBuilder.createSpellActive();
        spell.school = SpellSchools.FIRE;
        spell.group = PRIMARY_GROUP;
        spell.tier = 1;
        spell.range = 64.0f;
        spell.learn = new Spell.Learn();
        spell.active.scroll = new Spell.Active.Scroll();
        spell.active.cast.duration = 1.5f;
        spell.active.cast.animation = "spell_engine:one_handed_projectile_charge";
        spell.active.cast.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_CASTING.id(), 0.0f);
        spell.active.cast.particles = new ParticleBatch[]{WizardSpells.fireCastingParticles()};
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_projectile_release";
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.deliver.type = Spell.Delivery.Type.PROJECTILE;
        spell.deliver.projectile = new Spell.Delivery.ShootProjectile();
        spell.deliver.projectile.launch_properties.velocity = 1.25f;
        spell.deliver.projectile.launch_properties.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_RELEASE.id());
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.homing_angle = 1.0f;
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.light_level = 12;
        projectile.client_data.travel_particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame_spark.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 4.0f, 0.0f, 0.1f, 0.0f), new ParticleBatch(SpellEngineParticles.flame_medium_b.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 3.0f, 0.0f, 0.1f, 0.0f), new ParticleBatch("smoke", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 2.0f, 0.0f, 0.1f, 0.0f)};
        projectile.client_data.model = new Spell.ProjectileModel();
        projectile.client_data.model.model_id = "wizards:projectile/fire_blast";
        projectile.client_data.model.scale = 0.9f;
        spell.deliver.projectile.projectile = projectile;
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)1.0f, (float)1.1f);
        damage.particles = new ParticleBatch[]{new ParticleBatch("lava", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 15.0f, 0.5f, 3.0f), new ParticleBatch(SpellEngineParticles.flame_medium_b.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 10.0f, 0.1f, 0.2f)};
        spell.impacts = List.of(damage);
        spell.area_impact = new Spell.AreaImpact();
        spell.area_impact.radius = 2.5f;
        spell.area_impact.area.distance_dropoff = Spell.Target.Area.DropoffCurve.SQUARED;
        spell.area_impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.fire_explosion.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 2.0f, 0.2f, 0.5f)};
        spell.area_impact.sound = new Sound(WizardsSounds.FIREBALL_IMPACT.id());
        WizardSpells.configureFireRuneCost(spell);
        return new Entry(id, spell, "", "", null);
    }

    private static Entry fire_breath() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"fire_breath");
        Spell spell = SpellBuilder.createSpellActive();
        spell.school = SpellSchools.FIRE;
        spell.tier = 2;
        spell.range = 10.0f;
        spell.learn = new Spell.Learn();
        spell.active.scroll = new Spell.Active.Scroll();
        SpellBuilder.Casting.channel((Spell)spell, (float)5.0f, (int)4);
        spell.active.cast.animation = "spell_engine:two_handed_channeling";
        spell.active.cast.sound = new Sound(WizardsSounds.FIRE_BREATH_CASTING.id(), 0.0f);
        spell.active.cast.start_sound = new Sound(WizardsSounds.FIRE_BREATH_START.id());
        spell.active.cast.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame.id().toString(), ParticleBatch.Shape.CONE, ParticleBatch.Origin.LAUNCH_POINT, ParticleBatch.Rotation.LOOK, 8.0f, 1.0f, 1.0f, 30.0f), new ParticleBatch(SpellEngineParticles.flame_medium_a.id().toString(), ParticleBatch.Shape.CONE, ParticleBatch.Origin.LAUNCH_POINT, ParticleBatch.Rotation.LOOK, 4.0f, 1.0f, 1.0f, 30.0f), new ParticleBatch(SpellEngineParticles.flame_medium_b.id().toString(), ParticleBatch.Shape.CONE, ParticleBatch.Origin.LAUNCH_POINT, ParticleBatch.Rotation.LOOK, 4.0f, 1.0f, 1.0f, 30.0f)};
        spell.release = new Spell.Release();
        spell.release.sound = new Sound(WizardsSounds.FIRE_BREATH_RELEASE.id());
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
        spell.target.area.distance_dropoff = Spell.Target.Area.DropoffCurve.SQUARED;
        spell.target.area.angle_degrees = 40.0f;
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.9f, (float)0.9f);
        damage.particles = new ParticleBatch[]{new ParticleBatch("lava", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 3.0f, 0.5f, 3.0f)};
        damage.sound = new Sound(WizardsSounds.FIRE_BREATH_IMPACT.id());
        Spell.Impact fire = SpellBuilder.Impacts.fire((float)2.0f);
        spell.impacts = List.of(damage, fire);
        SpellBuilder.Cost.exhaust((Spell)spell, (float)0.2f);
        WizardSpells.configureFireRuneCost(spell);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)10.0f);
        spell.cost.cooldown.proportional = true;
        return new Entry(id, spell, "", "", null);
    }

    private static Entry fire_meteor() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"fire_meteor");
        Spell spell = SpellBuilder.createSpellActive();
        spell.school = SpellSchools.FIRE;
        spell.tier = 3;
        spell.range = 32.0f;
        spell.learn = new Spell.Learn();
        spell.active.scroll = new Spell.Active.Scroll();
        spell.active.cast.duration = 1.0f;
        spell.active.cast.animation = "spell_engine:one_handed_projectile_charge";
        spell.active.cast.sound = new Sound(SpellEngineSounds.GENERIC_FIRE_CASTING.id(), 0.0f);
        spell.active.cast.particles = new ParticleBatch[]{WizardSpells.fireCastingParticles()};
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_area_release";
        spell.release.sound = new Sound(WizardsSounds.FIRE_METEOR_RELEASE.id());
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.sticky = true;
        spell.deliver.type = Spell.Delivery.Type.METEOR;
        spell.deliver.meteor = new Spell.Delivery.Meteor();
        spell.deliver.meteor.launch_height = 10.0f;
        spell.deliver.meteor.launch_radius = 4.0f;
        spell.deliver.meteor.launch_properties.velocity = 0.8f;
        spell.deliver.meteor.launch_properties.extra_launch_count = 2;
        spell.deliver.meteor.launch_properties.extra_launch_delay = 5;
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.light_level = 12;
        projectile.client_data.travel_particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 3.0f, 0.0f, 0.1f, 0.0f), new ParticleBatch("smoke", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 5.0f, 0.1f, 0.3f, 0.0f), new ParticleBatch("campfire_cosy_smoke", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 6.0f, 0.0f, 0.05f, 0.0f)};
        projectile.client_data.model = new Spell.ProjectileModel();
        projectile.client_data.model.model_id = "wizards:projectile/fire_meteor";
        spell.deliver.meteor.projectile = projectile;
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)1.0f, (float)2.0f);
        damage.action.damage.spell_power_coefficient = 1.0f;
        damage.particles = new ParticleBatch[]{new ParticleBatch("lava", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 3.0f, 0.5f, 3.0f)};
        damage.sound = new Sound(WizardsSounds.FIRE_BREATH_IMPACT.id());
        spell.impacts = List.of(damage);
        spell.area_impact = new Spell.AreaImpact();
        spell.area_impact.radius = 6.0f;
        spell.area_impact.area.distance_dropoff = Spell.Target.Area.DropoffCurve.SQUARED;
        spell.area_impact.particles = new ParticleBatch[]{new ParticleBatch("lava", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 90.0f, 1.5f, 6.0f), new ParticleBatch("flame", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 100.0f, 0.2f, 0.4f), new ParticleBatch("smoke", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 90.0f, 0.1f, 0.3f)};
        spell.area_impact.sound = Sound.withVolume((ResourceLocation)WizardsSounds.FIRE_METEOR_IMPACT.id(), (float)1.5f);
        SpellBuilder.Cost.exhaust((Spell)spell, (float)0.3f);
        WizardSpells.configureFireRuneCost(spell);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)10.0f);
        return new Entry(id, spell, "", "", null);
    }

    private static Entry fire_wall() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"fire_wall");
        String name = "Wall of Flames";
        String description = "Creates a wall of fire, lasting {cloud_duration} seconds, dealing up to {damage} fire spell damage continuously to enemies passing thru.";
        Spell spell = SpellBuilder.createSpellActive();
        spell.range = 0.0f;
        spell.tier = 4;
        spell.school = SpellSchools.FIRE;
        spell.learn = new Spell.Learn();
        SpellBuilder.Casting.instant((Spell)spell);
        SpellBuilder.Release.visuals((Spell)spell, (String)"spell_engine:one_handed_area_release_ground_left_to_right", null, null);
        spell.deliver.type = Spell.Delivery.Type.CLOUD;
        Spell.Delivery.Cloud cloud = new Spell.Delivery.Cloud();
        cloud.volume.radius = 0.9f;
        cloud.volume.area.vertical_range_multiplier = 4.0f;
        cloud.volume.sound = new Sound(WizardsSounds.FIRE_SCORCH_IMPACT.id());
        cloud.delay_ticks = 0;
        cloud.impact_tick_interval = 8;
        cloud.time_to_live_seconds = 8.0f;
        cloud.spawn = new Spell.Delivery.Cloud.Spawn();
        cloud.spawn.sound = new Sound(WizardsSounds.FIRE_WALL_IGNITE.id());
        cloud.spawn.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 15.0f, 0.1f, 0.5f)};
        cloud.client_data = new Spell.Delivery.Cloud.ClientData();
        cloud.client_data.light_level = 15;
        cloud.client_data.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame_ground.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 2.0f, 0.0f, 0.0f), new ParticleBatch(SpellEngineParticles.flame_medium_a.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 3.0f, 0.02f, 0.3f), new ParticleBatch(SpellEngineParticles.flame_medium_b.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 3.0f, 0.01f, 0.35f), new ParticleBatch(SpellEngineParticles.flame_spark.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 4.0f, 0.05f, 0.3f), new ParticleBatch("campfire_cosy_smoke", ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 0.1f, 0.05f, 0.1f)};
        cloud.placement = SpellBuilder.Deliver.placementByLook((float)4.4f, (float)-64.0f, (int)0);
        cloud.additional_placements = List.of(SpellBuilder.Deliver.placementByLook((float)2.8f, (float)-45.0f, (int)4), SpellBuilder.Deliver.placementByLook((float)2.0f, (float)0.0f, (int)4), SpellBuilder.Deliver.placementByLook((float)2.8f, (float)45.0f, (int)4), SpellBuilder.Deliver.placementByLook((float)4.4f, (float)64.0f, (int)4));
        spell.deliver.clouds = List.of(cloud);
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.8f, (float)0.4f);
        damage.particles = new ParticleBatch[]{new ParticleBatch("smoke", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.01f, 0.1f), new ParticleBatch("flame", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 10.0f, 0.01f, 0.1f)};
        damage.sound = new Sound(WizardsSounds.FIRE_SCORCH_IMPACT.id());
        Spell.Impact fire = SpellBuilder.Impacts.fire((float)2.0f);
        spell.impacts = List.of(damage, fire);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)24.0f);
        SpellBuilder.Cost.item((Spell)spell, (String)"runes:fire_stone", (int)1);
        SpellBuilder.Cost.exhaust((Spell)spell, (float)0.4f);
        return new Entry(id, spell, name, description, null);
    }

    private static Entry frost_shard() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"frost_shard");
        Spell spell = SpellBuilder.createSpellActive();
        spell.school = SpellSchools.FROST;
        spell.group = PRIMARY_GROUP;
        spell.tier = 0;
        spell.range = 48.0f;
        spell.active.cast.duration = 1.0f;
        spell.active.cast.animation = "spell_engine:one_handed_projectile_charge";
        spell.active.cast.sound = new Sound(SpellEngineSounds.GENERIC_FROST_CASTING.id(), 0.0f);
        spell.active.cast.particles = new ParticleBatch[]{WizardSpells.frostCastingParticles()};
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_projectile_release";
        spell.release.sound = new Sound(SpellEngineSounds.GENERIC_FROST_RELEASE.id());
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.deliver.type = Spell.Delivery.Type.PROJECTILE;
        spell.deliver.projectile = new Spell.Delivery.ShootProjectile();
        spell.deliver.projectile.launch_properties.velocity = 1.2f;
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.perks.bounce = 2;
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.travel_particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.FROST, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 1.0f, 0.1f, 0.2f, 0.0f).color(FROST_COLOR.toRGBA())};
        projectile.client_data.model = new Spell.ProjectileModel();
        projectile.client_data.model.model_id = "wizards:projectile/frost_shard";
        projectile.client_data.model.scale = 0.75f;
        spell.deliver.projectile.projectile = projectile;
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.6f, (float)1.0f);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.FROST, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.2f, 0.7f).color(FROST_COLOR.toRGBA())};
        damage.sound = new Sound(WizardsSounds.FROST_SHARD_IMPACT.id());
        spell.impacts = List.of(damage);
        WizardSpells.configureFrostRuneCost(spell);
        return new Entry(id, spell, "", "", null);
    }

    private static Entry frostbolt() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"frostbolt");
        Spell spell = SpellBuilder.createSpellActive();
        spell.school = SpellSchools.FROST;
        spell.group = PRIMARY_GROUP;
        spell.tier = 1;
        spell.sub_tier = 2;
        spell.range = 64.0f;
        spell.learn = new Spell.Learn();
        spell.active.scroll = new Spell.Active.Scroll();
        spell.active.cast.duration = 1.1f;
        spell.active.cast.animation = "spell_engine:one_handed_projectile_charge";
        spell.active.cast.sound = new Sound(SpellEngineSounds.GENERIC_FROST_CASTING.id(), 0.0f);
        spell.active.cast.particles = new ParticleBatch[]{WizardSpells.frostCastingParticles()};
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_projectile_release";
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.deliver.type = Spell.Delivery.Type.PROJECTILE;
        spell.deliver.projectile = new Spell.Delivery.ShootProjectile();
        spell.deliver.projectile.launch_properties.velocity = 1.2f;
        spell.deliver.projectile.launch_properties.sound = new Sound(SpellEngineSounds.GENERIC_FROST_RELEASE.id());
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.homing_angle = 2.0f;
        projectile.perks.ricochet = 2;
        projectile.perks.bounce = 2;
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.light_level = 12;
        projectile.client_data.travel_particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 4.0f, 0.0f, 0.1f, 0.0f), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.FROST, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 1.0f, 0.1f, 0.2f, 0.0f).color(FROST_COLOR.toRGBA())};
        projectile.client_data.model = new Spell.ProjectileModel();
        projectile.client_data.model.model_id = "wizards:projectile/frostbolt";
        projectile.client_data.model.scale = 0.5f;
        spell.deliver.projectile.projectile = projectile;
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.8f, (float)1.0f);
        damage.particles = WizardSpells.frostImpactParticles();
        damage.sound = new Sound(SpellEngineSounds.GENERIC_FROST_IMPACT.id());
        Spell.Impact slowness = SpellBuilder.Impacts.effectAdd((String)WizardsEffects.frostSlowness.id.toString(), (float)5.0f, (int)0, (int)1);
        slowness.action.status_effect.apply_limit = new Spell.Impact.Action.StatusEffect.ApplyLimit();
        slowness.action.status_effect.apply_limit.health_base = 100.0f;
        slowness.action.status_effect.apply_limit.spell_power_multiplier = 4.0f;
        slowness.action.status_effect.show_particles = false;
        slowness.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 0.1f, 0.4f)};
        spell.impacts = List.of(damage, slowness);
        WizardSpells.configureFrostRuneCost(spell);
        return new Entry(id, spell, "", "", null);
    }

    private static Entry frost_nova() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"frost_nova");
        Spell spell = SpellBuilder.createSpellActive();
        spell.school = SpellSchools.FROST;
        spell.tier = 2;
        spell.range = 6.0f;
        spell.learn = new Spell.Learn();
        spell.active.scroll = new Spell.Active.Scroll();
        spell.active.cast.duration = 0.5f;
        spell.active.cast.animation = "spell_engine:one_handed_area_charge";
        spell.active.cast.sound = new Sound(SpellEngineSounds.GENERIC_FROST_CASTING.id(), 0.0f);
        spell.active.cast.particles = new ParticleBatch[]{WizardSpells.frostCastingParticles()};
        spell.target.type = Spell.Target.Type.AREA;
        spell.target.area = new Spell.Target.Area();
        spell.target.area.vertical_range_multiplier = 0.5f;
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_area_release";
        spell.release.sound = new Sound(WizardsSounds.FROST_NOVA_RELEASE.id());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 130.0f, 0.2f, 0.6f), new ParticleBatch(SpellEngineParticles.frost_shard.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, 130.0f, 0.5f, 0.9f)};
        spell.release.particles_scaled_with_ranged = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.area_effect_293.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.GROUND, 1.0f, 0.0f, 0.0f).scale(0.8f).color(2582052863L)};
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.5f, (float)0.8f);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.FROST, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 30.0f, 0.2f, 0.7f).color(FROST_COLOR.toRGBA())};
        damage.sound = new Sound(WizardsSounds.FROST_NOVA_DAMAGE_IMPACT.id());
        Spell.Impact frozen = SpellBuilder.Impacts.effectAdd((String)WizardsEffects.frozen.id.toString(), (float)6.0f, (int)1, (int)9);
        frozen.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.ADD;
        frozen.action.status_effect.apply_limit = new Spell.Impact.Action.StatusEffect.ApplyLimit();
        frozen.action.status_effect.apply_limit.health_base = 60.0f;
        frozen.action.status_effect.apply_limit.spell_power_multiplier = 4.0f;
        frozen.action.status_effect.show_particles = false;
        frozen.sound = new Sound(WizardsSounds.FROST_NOVA_EFFECT_IMPACT.id());
        spell.impacts = List.of(damage, frozen);
        SpellBuilder.Cost.exhaust((Spell)spell, (float)0.2f);
        WizardSpells.configureFrostRuneCost(spell);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)10.0f);
        return new Entry(id, spell, "", "", null);
    }

    private static Entry frost_shield() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"frost_shield");
        Spell spell = SpellBuilder.createSpellActive();
        spell.school = SpellSchools.FROST;
        spell.tier = 3;
        spell.range = 0.0f;
        spell.learn = new Spell.Learn();
        spell.active.scroll = new Spell.Active.Scroll();
        SpellBuilder.Casting.instant((Spell)spell);
        spell.release = new Spell.Release();
        spell.release.animation = "spell_engine:one_handed_area_release";
        spell.release.sound = new Sound(WizardsSounds.FROST_SHIELD_RELEASE.id());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 90.0f, 0.1f, 0.35f), new ParticleBatch(SpellEngineParticles.frost_shard.id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 50.0f, 0.1f, 0.3f)};
        Spell.Impact shield = SpellBuilder.Impacts.effectSet((String)WizardsEffects.frostShield.id.toString(), (float)8.0f, (int)0);
        shield.action.status_effect.show_particles = false;
        spell.impacts = List.of(shield);
        SpellBuilder.Cost.exhaust((Spell)spell, (float)0.3f);
        WizardSpells.configureFrostRuneCost(spell);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)30.0f);
        return new Entry(id, spell, "", "", null);
    }

    private static Entry frost_blizzard() {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"wizards", (String)"frost_blizzard");
        Spell spell = SpellBuilder.createSpellActive();
        spell.school = SpellSchools.FROST;
        spell.tier = 4;
        spell.range = 32.0f;
        spell.learn = new Spell.Learn();
        spell.active.scroll = new Spell.Active.Scroll();
        SpellBuilder.Casting.channel((Spell)spell, (float)8.0f, (int)12);
        spell.active.cast.animation = "spell_engine:one_handed_sky_charge";
        spell.active.cast.sound = new Sound(WizardsSounds.FROST_BLIZZARD_CASTING.id(), 0.0f);
        spell.active.cast.particles = new ParticleBatch[]{WizardSpells.frostCastingParticles()};
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.sticky = true;
        spell.deliver.type = Spell.Delivery.Type.METEOR;
        spell.deliver.meteor = new Spell.Delivery.Meteor();
        spell.deliver.meteor.launch_radius = 3.0f;
        spell.deliver.meteor.launch_properties.velocity = 1.0f;
        spell.deliver.meteor.launch_properties.extra_launch_count = 3;
        spell.deliver.meteor.launch_properties.extra_launch_delay = 4;
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.divergence = 8.0f;
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.travel_particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 3.0f, 0.0f, 0.1f, 0.0f), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.FROST, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 1.0f, 0.1f, 0.2f, 0.0f).color(FROST_COLOR.toRGBA())};
        projectile.client_data.model = new Spell.ProjectileModel();
        projectile.client_data.model.model_id = "wizards:projectile/frost_shard";
        projectile.client_data.model.scale = 0.8f;
        spell.deliver.meteor.projectile = projectile;
        spell.release = new Spell.Release();
        spell.release.sound = new Sound(WizardsSounds.FIRE_BREATH_RELEASE.id());
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.7f, (float)0.2f);
        damage.sound = new Sound(SpellEngineSounds.GENERIC_FROST_IMPACT.id());
        Spell.Impact slowness = SpellBuilder.Impacts.effectAdd((String)WizardsEffects.frostSlowness.id.toString(), (float)3.0f, (int)0, (int)1);
        slowness.action.status_effect.apply_limit = new Spell.Impact.Action.StatusEffect.ApplyLimit();
        slowness.action.status_effect.apply_limit.health_base = 80.0f;
        slowness.action.status_effect.apply_limit.spell_power_multiplier = 4.0f;
        slowness.action.status_effect.show_particles = false;
        slowness.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.FROST, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.2f, 0.7f).color(FROST_COLOR.toRGBA()), new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 5.0f, 0.1f, 0.4f)};
        spell.impacts = List.of(damage, slowness);
        spell.area_impact = new Spell.AreaImpact();
        spell.area_impact.radius = 3.0f;
        spell.area_impact.area.distance_dropoff = Spell.Target.Area.DropoffCurve.SQUARED;
        spell.area_impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.snowflake.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 20.0f, 0.1f, 0.3f), new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.FROST, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.2f, 0.4f).color(FROST_COLOR.toRGBA()), new ParticleBatch(SpellEngineParticles.frost_shard.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.2f, 0.4f)};
        spell.area_impact.sound = Sound.withVolume((ResourceLocation)WizardsSounds.FROST_SHARD_IMPACT.id(), (float)1.5f);
        SpellBuilder.Cost.exhaust((Spell)spell, (float)0.4f);
        WizardSpells.configureFrostRuneCost(spell);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)16.0f);
        spell.cost.cooldown.proportional = true;
        return new Entry(id, spell, "", "", null);
    }

    public record Entry(ResourceLocation id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator) {
    }
}

