/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.workarounds.context_creation;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.platform.ScreenManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.WindowEventHandler;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.caffeinemc.mods.sodium.client.compatibility.checks.ModuleScanner;
import net.caffeinemc.mods.sodium.client.compatibility.checks.PostLaunchChecks;
import net.caffeinemc.mods.sodium.client.compatibility.environment.GlContextInfo;
import net.caffeinemc.mods.sodium.client.compatibility.workarounds.nvidia.NvidiaWorkarounds;
import net.caffeinemc.mods.sodium.client.platform.NativeWindowHandle;
import net.caffeinemc.mods.sodium.client.services.PlatformRuntimeInformation;
import net.minecraft.Util;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.WGL;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Window.class})
public class WindowMixin {
    @Shadow
    @Final
    private static Logger LOGGER;
    @Unique
    private long wglPrevContext = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwCreateWindow(IILjava/lang/CharSequence;JJ)J"), expect=0, require=0)
    private long wrapGlfwCreateWindow(int width, int height, CharSequence title, long monitor, long share) {
        NvidiaWorkarounds.applyEnvironmentChanges();
        try {
            long l = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)title, (long)monitor, (long)share);
            return l;
        }
        finally {
            NvidiaWorkarounds.undoEnvironmentChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/neoforged/fml/loading/ImmediateWindowHandler;setupMinecraftWindow(Ljava/util/function/IntSupplier;Ljava/util/function/IntSupplier;Ljava/util/function/Supplier;Ljava/util/function/LongSupplier;)J")}, expect=0, require=0)
    private long wrapGlfwCreateWindowForge(IntSupplier width, IntSupplier height, Supplier<String> title, LongSupplier monitor, Operation<Long> op) {
        boolean applyWorkaroundsLate;
        boolean bl = applyWorkaroundsLate = !PlatformRuntimeInformation.getInstance().platformHasEarlyLoadingScreen();
        if (applyWorkaroundsLate) {
            NvidiaWorkarounds.applyEnvironmentChanges();
        }
        try {
            long l = (Long)op.call(new Object[]{width, height, title, monitor});
            return l;
        }
        finally {
            if (applyWorkaroundsLate) {
                NvidiaWorkarounds.undoEnvironmentChanges();
            }
        }
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL;createCapabilities()Lorg/lwjgl/opengl/GLCapabilities;", shift=At.Shift.AFTER)})
    private void postContextReady(WindowEventHandler eventHandler, ScreenManager monitorTracker, DisplayData settings, String videoMode, String title, CallbackInfo ci) {
        GlContextInfo context = GlContextInfo.create();
        LOGGER.info("OpenGL Vendor: {}", (Object)context.vendor());
        LOGGER.info("OpenGL Renderer: {}", (Object)context.renderer());
        LOGGER.info("OpenGL Version: {}", (Object)context.version());
        this.wglPrevContext = Util.getPlatform() == Util.OS.WINDOWS ? WGL.wglGetCurrentContext() : 0L;
        PostLaunchChecks.onContextInitialized((NativeWindowHandle)((NativeWindowHandle)this), (GlContextInfo)context);
        ModuleScanner.checkModules((NativeWindowHandle)((NativeWindowHandle)this));
    }

    @Inject(method={"updateDisplay"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;flipFrame(J)V", shift=At.Shift.AFTER)})
    private void preSwapBuffers(CallbackInfo ci) {
        if (this.wglPrevContext == 0L) {
            return;
        }
        long context = WGL.wglGetCurrentContext();
        if (this.wglPrevContext == context) {
            return;
        }
        LOGGER.warn("The OpenGL context appears to have been suddenly replaced! Something has likely just injected into the game process.");
        ModuleScanner.checkModules((NativeWindowHandle)((NativeWindowHandle)this));
        this.wglPrevContext = context;
    }
}

