/*
 * Decompiled with CFR 0.152.
 */
package net.runes.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.runes.crafting.RuneCrafting;
import net.runes.crafting.RuneCraftingBlock;
import net.runes.crafting.RuneCraftingRecipeInput;

public class RuneCraftingRecipe
implements Recipe<RuneCraftingRecipeInput> {
    final Ingredient base;
    final Ingredient addition;
    final ItemStack result;
    public static final String NAME = "crafting";
    public static final RecipeType<RuneCraftingRecipe> TYPE = new RecipeType<RuneCraftingRecipe>(){

        public String toString() {
            return RuneCraftingRecipe.NAME;
        }
    };

    public RuneCraftingRecipe(Ingredient base, Ingredient addition, ItemStack result) {
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public boolean matches(RuneCraftingRecipeInput input, Level world) {
        return this.base.test(input.getItem(0)) && this.addition.test(input.getItem(1));
    }

    public ItemStack craft(RuneCraftingRecipeInput input, HolderLookup.Provider wrapperLookup) {
        ItemStack itemStack = input.base().transmuteCopy((ItemLike)this.result.getItem(), this.result.getCount());
        itemStack.applyComponents(this.result.getComponentsPatch());
        return itemStack;
    }

    public ItemStack getResultItem(HolderLookup.Provider registriesLookup) {
        return this.result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)RuneCraftingBlock.INSTANCE);
    }

    public RecipeSerializer<?> getSerializer() {
        return RuneCrafting.RECIPE_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return TYPE;
    }

    public boolean isIncomplete() {
        return Stream.of(this.base, this.addition).anyMatch(ingredient -> ingredient.getItems().length == 0);
    }

    public static class Serializer
    implements RecipeSerializer<RuneCraftingRecipe> {
        private static final MapCodec<RuneCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("base").forGetter(recipe -> recipe.base), (App)Ingredient.CODEC.fieldOf("addition").forGetter(recipe -> recipe.addition), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)instance, RuneCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RuneCraftingRecipe> PACKET_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        public MapCodec<RuneCraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RuneCraftingRecipe> streamCodec() {
            return PACKET_CODEC;
        }

        private static RuneCraftingRecipe read(RegistryFriendlyByteBuf buf) {
            Ingredient ingredient2 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            Ingredient ingredient3 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            return new RuneCraftingRecipe(ingredient2, ingredient3, itemStack);
        }

        private static void write(RegistryFriendlyByteBuf buf, RuneCraftingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.base);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.addition);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
        }
    }
}

