/*
 * Decompiled with CFR 0.152.
 */
package net.runes.crafting;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.runes.crafting.RuneCraftingScreenHandler;
import org.jetbrains.annotations.Nullable;

public class RuneCraftingBlock
extends CraftingTableBlock {
    public static final String NAME = "crafting_altar";
    public static final RuneCraftingBlock INSTANCE = new RuneCraftingBlock(BlockBehaviour.Properties.of().destroyTime(2.0f).noOcclusion());
    public static final BlockItem ITEM = new BlockItem((Block)INSTANCE, new Item.Properties());
    private static final Component SCREEN_TITLE = Component.translatable((String)"gui.runes.rune_crafting");
    public static final VoxelShape TOP_SHAPE = Block.box((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final VoxelShape MIDDLE_SHAPE = Block.box((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final VoxelShape BOTTOM_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)TOP_SHAPE, (VoxelShape[])new VoxelShape[]{MIDDLE_SHAPE, BOTTOM_SHAPE});
    private static DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public RuneCraftingBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        tooltip.add((Component)Component.translatable((String)"block.runes.crafting_altar.hint").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    public MenuProvider getMenuProvider(BlockState state, Level world, BlockPos pos) {
        return new SimpleMenuProvider((syncId, inventory, player) -> new RuneCraftingScreenHandler(syncId, inventory, ContainerLevelAccess.create((Level)world, (BlockPos)pos)), SCREEN_TITLE);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(world, pos));
        return InteractionResult.CONSUME;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        FACING = BlockStateProperties.HORIZONTAL_FACING;
        builder.add(new Property[]{FACING});
    }

    public boolean isTranslucent(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }
}

