/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.util.client;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.io.InputStream;
import mod.azure.azurelibarmor.AzureLib;
import mod.azure.azurelibarmor.common.cache.object.GeoCube;
import mod.azure.azurelibarmor.common.model.AzBone;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class RenderUtils {
    private static final Matrix4f TRANSLATE_MATRIX_CACHE = new Matrix4f();
    private static final Quaternionf X_QUATERNION_CACHE = new Quaternionf();
    private static final Quaternionf Y_QUATERNION_CACHE = new Quaternionf();
    private static final Quaternionf Z_QUATERNION_CACHE = new Quaternionf();

    public static void translateMatrixToBone(PoseStack poseStack, AzBone bone) {
        poseStack.translate(-bone.getPosX() / 16.0f, bone.getPosY() / 16.0f, bone.getPosZ() / 16.0f);
    }

    public static void rotateMatrixAroundBone(PoseStack poseStack, AzBone bone) {
        float rotX = bone.getRotX();
        float rotY = bone.getRotY();
        float rotZ = bone.getRotZ();
        if (rotZ != 0.0f) {
            poseStack.mulPose(Z_QUATERNION_CACHE.rotationXYZ(0.0f, 0.0f, rotZ));
        }
        if (rotY != 0.0f) {
            poseStack.mulPose(Y_QUATERNION_CACHE.rotationXYZ(0.0f, rotY, 0.0f));
        }
        if (rotX != 0.0f) {
            poseStack.mulPose(X_QUATERNION_CACHE.rotationXYZ(rotX, 0.0f, 0.0f));
        }
    }

    public static void rotateMatrixAroundCube(PoseStack poseStack, GeoCube cube) {
        Vec3 rotation = cube.rotation();
        if (rotation.z() != 0.0) {
            Z_QUATERNION_CACHE.identity().rotateZ((float)rotation.z());
            poseStack.mulPose(Z_QUATERNION_CACHE);
        }
        if (rotation.y() != 0.0) {
            Y_QUATERNION_CACHE.identity().rotateY((float)rotation.y());
            poseStack.mulPose(Y_QUATERNION_CACHE);
        }
        if (rotation.x() != 0.0) {
            X_QUATERNION_CACHE.identity().rotateX((float)rotation.x());
            poseStack.mulPose(X_QUATERNION_CACHE);
        }
    }

    public static void scaleMatrixForBone(PoseStack poseStack, AzBone bone) {
        poseStack.scale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void translateToPivotPoint(PoseStack poseStack, GeoCube cube) {
        Vec3 pivot = cube.pivot();
        poseStack.translate(pivot.x() / 16.0, pivot.y() / 16.0, pivot.z() / 16.0);
    }

    public static void translateToPivotPoint(PoseStack poseStack, AzBone bone) {
        poseStack.translate(bone.getPivotX() / 16.0f, bone.getPivotY() / 16.0f, bone.getPivotZ() / 16.0f);
    }

    public static void translateAwayFromPivotPoint(PoseStack poseStack, GeoCube cube) {
        Vec3 pivot = cube.pivot();
        poseStack.translate(-pivot.x() / 16.0, -pivot.y() / 16.0, -pivot.z() / 16.0);
    }

    public static void translateAwayFromPivotPoint(PoseStack poseStack, AzBone bone) {
        poseStack.translate(-bone.getPivotX() / 16.0f, -bone.getPivotY() / 16.0f, -bone.getPivotZ() / 16.0f);
    }

    public static void translateAndRotateMatrixForBone(PoseStack poseStack, AzBone bone) {
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
    }

    public static void prepMatrixForBone(PoseStack poseStack, AzBone bone) {
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
    }

    public static Matrix4f invertAndMultiplyMatrices(Matrix4f baseMatrix, Matrix4f inputMatrix) {
        inputMatrix = new Matrix4f((Matrix4fc)inputMatrix);
        inputMatrix.invert();
        inputMatrix.mul((Matrix4fc)baseMatrix);
        return inputMatrix;
    }

    public static void faceRotation(PoseStack poseStack, Entity animatable, float partialTick) {
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)animatable.yRotO, (float)animatable.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTick, (float)animatable.xRotO, (float)animatable.getXRot())));
    }

    public static Matrix4f translateMatrix(Matrix4f matrix, Vector3f vector) {
        TRANSLATE_MATRIX_CACHE.m30(vector.x).m31(vector.y).m32(vector.z);
        return matrix.add((Matrix4fc)TRANSLATE_MATRIX_CACHE);
    }

    @Nullable
    public static IntIntPair getTextureDimensions(ResourceLocation texture) {
        if (texture == null) {
            return null;
        }
        AbstractTexture originalTexture = null;
        Minecraft mc = Minecraft.getInstance();
        try {
            originalTexture = (AbstractTexture)mc.submit(() -> mc.getTextureManager().getTexture(texture)).get();
        }
        catch (Exception e) {
            AzureLib.LOGGER.warn("Failed to load image for id {}", (Object)texture);
            e.printStackTrace();
        }
        if (originalTexture == null) {
            return null;
        }
        NativeImage image = null;
        try {
            NativeImage nativeImage;
            if (originalTexture instanceof DynamicTexture) {
                DynamicTexture dynamicTexture = (DynamicTexture)originalTexture;
                nativeImage = dynamicTexture.getPixels();
            } else {
                nativeImage = NativeImage.read((InputStream)((Resource)mc.getResourceManager().getResource(texture).get()).open());
            }
            image = nativeImage;
        }
        catch (Exception e) {
            AzureLib.LOGGER.error("Failed to read image for id {}", (Object)texture);
            e.printStackTrace();
        }
        return image == null ? null : IntIntImmutablePair.of((int)image.getWidth(), (int)image.getHeight());
    }

    public static double getCurrentSystemTick() {
        return (double)System.nanoTime() / 1000000.0 / 50.0;
    }

    public static double getCurrentTick() {
        return Blaze3D.getTime() * 20.0;
    }

    public static float booleanToFloat(boolean input) {
        return input ? 1.0f : 0.0f;
    }

    public static Vec3 arrayToVec(double[] array) {
        return new Vec3(array[0], array[1], array[2]);
    }

    public static void matchModelPartRot(ModelPart from, AzBone to) {
        to.updateRotation(-from.xRot, -from.yRot, from.zRot);
    }

    public static void fixInvertedFlatCube(GeoCube cube, Vector3f normal) {
        if (normal.x() < 0.0f && (cube.size().y() == 0.0 || cube.size().z() == 0.0)) {
            normal.mul(-1.0f, 1.0f, 1.0f);
        }
        if (normal.y() < 0.0f && (cube.size().x() == 0.0 || cube.size().z() == 0.0)) {
            normal.mul(1.0f, -1.0f, 1.0f);
        }
        if (normal.z() < 0.0f && (cube.size().x() == 0.0 || cube.size().y() == 0.0)) {
            normal.mul(1.0f, 1.0f, -1.0f);
        }
    }
}

