/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.render.layer;

import java.util.function.Function;
import mod.azure.azurelibarmor.common.model.AzBone;
import mod.azure.azurelibarmor.common.render.AzRendererPipelineContext;
import mod.azure.azurelibarmor.common.render.layer.AzRenderLayer;
import mod.azure.azurelibarmor.common.util.client.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class AzBlockAndItemLayer<K, T>
implements AzRenderLayer<K, T> {
    protected final Function<AzBone, ItemStack> itemStackProvider;
    protected final Function<AzBone, BlockState> blockStateProvider;

    public AzBlockAndItemLayer() {
        this(bone -> null, bone -> null);
    }

    public AzBlockAndItemLayer(Function<AzBone, ItemStack> itemStackProvider, Function<AzBone, BlockState> blockStateProvider) {
        this.itemStackProvider = itemStackProvider;
        this.blockStateProvider = blockStateProvider;
    }

    @Override
    public void preRender(AzRendererPipelineContext<K, T> context) {
    }

    @Override
    public void render(AzRendererPipelineContext<K, T> context) {
    }

    @Override
    public void renderForBone(AzRendererPipelineContext<K, T> context, AzBone bone) {
        T animatable = context.animatable();
        ItemStack stack = this.itemStackForBone(bone, animatable);
        BlockState blockState = this.blockStateForBone(bone, animatable);
        if (stack == null && blockState == null) {
            return;
        }
        context.poseStack().pushPose();
        RenderUtils.translateAndRotateMatrixForBone(context.poseStack(), bone);
        if (stack != null) {
            this.renderItemForBone(context, bone, stack, animatable);
        }
        if (blockState != null) {
            this.renderBlockForBone(context, bone, blockState, animatable);
        }
        context.setVertexConsumer(context.multiBufferSource().getBuffer(context.renderType()));
        context.poseStack().popPose();
    }

    public ItemStack itemStackForBone(AzBone bone, T animatable) {
        return this.itemStackProvider.apply(bone);
    }

    public BlockState blockStateForBone(AzBone bone, T animatable) {
        return this.blockStateProvider.apply(bone);
    }

    protected ItemDisplayContext getTransformTypeForStack(AzBone bone, ItemStack stack, T animatable) {
        return ItemDisplayContext.NONE;
    }

    protected void renderItemForBone(AzRendererPipelineContext<K, T> context, AzBone bone, ItemStack itemStack, T animatable) {
        T t = context.animatable();
        if (t instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)t;
            Minecraft.getInstance().getItemRenderer().renderStatic(livingEntity, itemStack, this.getTransformTypeForStack(bone, itemStack, animatable), false, context.poseStack(), context.multiBufferSource(), livingEntity.level(), context.packedLight(), context.packedOverlay(), livingEntity.getId());
        } else {
            Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, this.getTransformTypeForStack(bone, itemStack, animatable), context.packedLight(), context.packedOverlay(), context.poseStack(), context.multiBufferSource(), (Level)Minecraft.getInstance().level, context.animatable().hashCode());
        }
    }

    protected void renderBlockForBone(AzRendererPipelineContext<K, T> context, AzBone bone, BlockState blockState, T animatable) {
        context.poseStack().pushPose();
        context.poseStack().translate(-0.25f, -0.25f, -0.25f);
        context.poseStack().scale(0.5f, 0.5f, 0.5f);
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(blockState, context.poseStack(), context.multiBufferSource(), context.packedLight(), OverlayTexture.NO_OVERLAY);
        context.poseStack().popPose();
    }
}

