/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.loading;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.nio.charset.Charset;
import mod.azure.azurelibarmor.AzureLib;
import mod.azure.azurelibarmor.common.animation.primitive.AzBakedAnimations;
import mod.azure.azurelibarmor.common.loading.json.raw.Model;
import mod.azure.azurelibarmor.common.util.AzureLibException;
import mod.azure.azurelibarmor.common.util.JsonUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;

public final class FileLoader {
    private FileLoader() {
        throw new UnsupportedOperationException();
    }

    public static AzBakedAnimations loadAzAnimationsFile(ResourceLocation location, ResourceManager manager) {
        try {
            return (AzBakedAnimations)JsonUtil.GEO_GSON.fromJson((JsonElement)FileLoader.loadFile(location, manager), AzBakedAnimations.class);
        }
        catch (Exception e) {
            FileLoader.logError(location);
            return null;
        }
    }

    public static Model loadModelFile(ResourceLocation location, ResourceManager manager) {
        try {
            return (Model)JsonUtil.GEO_GSON.fromJson((JsonElement)FileLoader.loadFile(location, manager), Model.class);
        }
        catch (Exception e) {
            FileLoader.logError(location);
            return null;
        }
    }

    public static JsonObject loadFile(ResourceLocation location, ResourceManager manager) {
        try {
            return (JsonObject)GsonHelper.fromJson((Gson)JsonUtil.GEO_GSON, (String)FileLoader.getFileContents(location, manager), JsonObject.class);
        }
        catch (Exception e) {
            FileLoader.logError(location);
            return null;
        }
    }

    public static String getFileContents(ResourceLocation location, ResourceManager manager) {
        String string;
        block8: {
            InputStream inputStream = manager.getResourceOrThrow(location).open();
            try {
                string = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    AzureLib.LOGGER.error("Couldn't load {}", (Object)location, (Object)e);
                    throw new AzureLibException(location.toString());
                }
            }
            inputStream.close();
        }
        return string;
    }

    private static void logError(Object args) {
        AzureLib.LOGGER.warn("Error parsing JSON from {}: skipping", args);
    }
}

