/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.common.cache;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import mod.azure.azurelibarmor.common.animation.cache.AzBakedAnimationCache;
import mod.azure.azurelibarmor.common.model.cache.AzBakedModelCache;
import mod.azure.azurelibarmor.common.util.AzureLibException;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public final class AzureLibCache {
    private AzureLibCache() {
        throw new UnsupportedOperationException();
    }

    public static void registerReloadListener() {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null) {
            return;
        }
        ResourceManager resourceManager = mc.getResourceManager();
        if (!(resourceManager instanceof ReloadableResourceManager)) {
            throw new AzureLibException("AzureLib was initialized too early!");
        }
        ReloadableResourceManager resourceManager2 = (ReloadableResourceManager)resourceManager;
        resourceManager2.registerReloadListener(AzureLibCache::reload);
    }

    public static CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.allOf(AzBakedAnimationCache.getInstance().loadAnimations(backgroundExecutor, resourceManager), AzBakedModelCache.getInstance().loadModels(backgroundExecutor, resourceManager)).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0))).thenAcceptAsync(empty -> {}, gameExecutor);
    }
}

