/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.structure_pool.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabric_extras.structure_pool.api.StructurePoolAPI;
import net.fabric_extras.structure_pool.internal.StructurePoolExtension;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={JigsawPlacement.Placer.class})
public class StructurePoolBasedGenerator_StructurePoolGeneratorMixin {
    @Shadow
    @Final
    private Registry<StructureTemplatePool> pools;
    private HashMap<ResourceLocation, HashMap<ResourceLocation, Integer>> limitedSpawns = new HashMap();
    @Nullable
    private ResourceLocation currentPoolId;

    @WrapOperation(method={"tryPlacingChildren(Lnet/minecraft/world/level/levelgen/structure/PoolElementStructurePiece;Lorg/apache/commons/lang3/mutable/MutableObject;IZLnet/minecraft/world/level/LevelHeightAccessor;Lnet/minecraft/world/level/levelgen/RandomState;Lnet/minecraft/world/level/levelgen/structure/pools/alias/PoolAliasLookup;Lnet/minecraft/world/level/levelgen/structure/templatesystem/LiquidSettings;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/structure/pools/JigsawPlacement$Placer;readPoolKey(Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate$StructureBlockInfo;Lnet/minecraft/world/level/levelgen/structure/pools/alias/PoolAliasLookup;)Lnet/minecraft/resources/ResourceKey;")})
    private ResourceKey<StructureTemplatePool> getPoolKey_Wrapped(StructureTemplate.StructureBlockInfo structureBlockInfo, PoolAliasLookup aliasLookup, Operation<ResourceKey<StructureTemplatePool>> original) {
        ResourceKey key = (ResourceKey)original.call(new Object[]{structureBlockInfo, aliasLookup});
        ResourceLocation poolId = key.location();
        if (!this.limitedSpawns.containsKey(poolId) && StructurePoolAPI.spawnLimitations.containsKey(poolId)) {
            HashMap<ResourceLocation, Integer> freshLimitations = new HashMap<ResourceLocation, Integer>();
            for (Map.Entry<ResourceLocation, StructurePoolAPI.SpawnPerk> entry : StructurePoolAPI.spawnLimitations.get(poolId).entrySet()) {
                ResourceLocation structureId = entry.getKey();
                StructurePoolAPI.SpawnPerk spawnPerk = entry.getValue();
                int spawnLimit = spawnPerk.limit();
                freshLimitations.put(structureId, spawnLimit);
            }
            this.limitedSpawns.put(poolId, freshLimitations);
        }
        this.currentPoolId = key.location();
        return key;
    }

    @WrapOperation(method={"tryPlacingChildren(Lnet/minecraft/world/level/levelgen/structure/PoolElementStructurePiece;Lorg/apache/commons/lang3/mutable/MutableObject;IZLnet/minecraft/world/level/LevelHeightAccessor;Lnet/minecraft/world/level/levelgen/RandomState;Lnet/minecraft/world/level/levelgen/structure/pools/alias/PoolAliasLookup;Lnet/minecraft/world/level/levelgen/structure/templatesystem/LiquidSettings;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/levelgen/structure/pools/StructureTemplatePool;getShuffledTemplates(Lnet/minecraft/util/RandomSource;)Ljava/util/List;")})
    private List<StructurePoolElement> getElementIndicesInRandomOrder_Wrapped(StructureTemplatePool pool, RandomSource random, Operation<List<StructurePoolElement>> original) {
        List result = (List)original.call(new Object[]{pool, random});
        result.removeIf(element -> !this.limitAllowsSpawn((StructurePoolElement)element));
        return result;
    }

    @WrapOperation(method={"tryPlacingChildren(Lnet/minecraft/world/level/levelgen/structure/PoolElementStructurePiece;Lorg/apache/commons/lang3/mutable/MutableObject;IZLnet/minecraft/world/level/LevelHeightAccessor;Lnet/minecraft/world/level/levelgen/RandomState;Lnet/minecraft/world/level/levelgen/structure/pools/alias/PoolAliasLookup;Lnet/minecraft/world/level/levelgen/structure/templatesystem/LiquidSettings;)V"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z")})
    private boolean children_Wrapped(List list, Object object, Operation<Boolean> original) {
        if (object instanceof PoolElementStructurePiece) {
            PoolElementStructurePiece piece = (PoolElementStructurePiece)object;
            this.consumeLimit(piece.getElement());
        }
        return (Boolean)original.call(new Object[]{list, object});
    }

    @Unique
    @Nullable
    private ResourceLocation resolveStructureElementId(StructurePoolElement element) {
        if (this.currentPoolId == null) {
            return null;
        }
        StructureTemplatePool pool = (StructureTemplatePool)this.pools.get(this.currentPoolId);
        if (pool == null) {
            return null;
        }
        return ((StructurePoolExtension)pool).identify(element);
    }

    private boolean limitAllowsSpawn(StructurePoolElement element) {
        ResourceLocation structureId = this.resolveStructureElementId(element);
        if (structureId == null) {
            return true;
        }
        if (!this.limitedSpawns.containsKey(this.currentPoolId)) {
            return true;
        }
        if (!this.limitedSpawns.get(this.currentPoolId).containsKey(structureId)) {
            return true;
        }
        Integer limit = this.limitedSpawns.get(this.currentPoolId).get(structureId);
        return limit > 0;
    }

    private void consumeLimit(StructurePoolElement element) {
        ResourceLocation structureId = this.resolveStructureElementId(element);
        if (structureId == null) {
            return;
        }
        HashMap<ResourceLocation, Integer> poolSpecificLimits = this.limitedSpawns.get(this.currentPoolId);
        if (poolSpecificLimits == null) {
            return;
        }
        if (!poolSpecificLimits.containsKey(structureId)) {
            return;
        }
        Integer limit = poolSpecificLimits.get(structureId);
        if (limit > 0) {
            poolSpecificLimits.put(structureId, limit - 1);
        }
    }
}

