/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import vectorwing.farmersdelight.common.item.FuelBlockItem;

public class RopeItem
extends FuelBlockItem {
    public RopeItem(Block block, Item.Properties properties) {
        super(block, properties, 200);
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos);
        Block block = this.getBlock();
        if (state.getBlock() != block) {
            return context;
        }
        Direction direction = context.isSecondaryUseActive() ? context.getClickedFace() : Direction.DOWN;
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ()).move(direction);
        for (int i = 0; i < 256; ++i) {
            state = level.getBlockState((BlockPos)blockpos$mutable);
            if (state.getBlock() != this.getBlock()) {
                FluidState fluid = state.getFluidState();
                if (!fluid.is(FluidTags.WATER) && !fluid.isEmpty()) {
                    return null;
                }
                if (!state.canBeReplaced(context)) break;
                return BlockPlaceContext.at((BlockPlaceContext)context, (BlockPos)blockpos$mutable, (Direction)direction);
            }
            if (direction != Direction.DOWN) {
                return context;
            }
            blockpos$mutable.move(direction);
        }
        return null;
    }

    protected boolean mustSurvive() {
        return false;
    }
}

