/*
 * Decompiled with CFR 0.152.
 */
package net.archers.mixin.screen;

import net.archers.item.misc.AutoFireHook;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilScreenHandlerMixin
extends ItemCombinerMenu {
    @Shadow
    @Final
    private DataSlot cost;

    public AnvilScreenHandlerMixin(@Nullable MenuType<?> type, int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super(type, syncId, playerInventory, context);
    }

    @Inject(method={"createResult()V"}, at={@At(value="RETURN")})
    private void updateResult_Inject(CallbackInfo ci) {
        Container input = this.inputSlots;
        ItemStack input1 = input.getItem(0);
        ItemStack input2 = input.getItem(1);
        if (input1.isEmpty() || input2.isEmpty()) {
            return;
        }
        ItemStack afh = null;
        ItemStack crossbow = null;
        if (input1.is(AutoFireHook.item) && AutoFireHook.isApplicable(input2)) {
            afh = input1;
            crossbow = input2;
        } else if (AutoFireHook.isApplicable(input1) && input2.is(AutoFireHook.item)) {
            afh = input2;
            crossbow = input1;
        }
        if (afh == null || crossbow == null || !AutoFireHook.isApplicable(crossbow)) {
            return;
        }
        ItemStack afhCrossbow = crossbow.copy();
        AutoFireHook.apply(afhCrossbow);
        this.resultSlots.setItem(0, afhCrossbow);
        this.cost.set(1);
        this.broadcastChanges();
    }
}

