/*
 * Decompiled with CFR 0.152.
 */
package net.archers.item.misc;

import net.archers.component.ArcherComponents;
import net.archers.item.misc.AutoFireHookItem;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AutoFireHook {
    public static final ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"archers", (String)"auto_fire_hook");
    public static final Item item = new AutoFireHookItem(new Item.Properties().stacksTo(1));
    public static final TagKey<Item> AFH_ATTACHABLE = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"archers", (String)"auto_fire_hook_attachables"));

    public static boolean isApplied(ItemStack itemStack) {
        Boolean component = (Boolean)itemStack.get(ArcherComponents.AUTO_FIRE);
        if (component == null) {
            return false;
        }
        return component;
    }

    public static void apply(ItemStack itemStack) {
        itemStack.set(ArcherComponents.AUTO_FIRE, (Object)true);
    }

    public static void remove(ItemStack itemStack) {
        itemStack.remove(ArcherComponents.AUTO_FIRE);
    }

    public static boolean isApplicable(ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return false;
        }
        return (itemStack.getItem() instanceof CrossbowItem || itemStack.is(AFH_ATTACHABLE)) && !AutoFireHook.isApplied(itemStack);
    }
}

