/*
 * Decompiled with CFR 0.152.
 */
package net.archers;

import net.archers.block.ArcherBlocks;
import net.archers.config.ArchersItemConfig;
import net.archers.config.Default;
import net.archers.config.TweaksConfig;
import net.archers.content.ArcherSounds;
import net.archers.effect.ArcherEffects;
import net.archers.item.ArcherArmors;
import net.archers.item.ArcherWeapons;
import net.archers.item.Group;
import net.archers.item.misc.Misc;
import net.archers.village.ArcherVillagers;
import net.fabric_extras.structure_pool.api.StructurePoolAPI;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabricmc.fabric.api.item.v1.EnchantmentEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.config.ConfigFile;
import net.spell_engine.api.item.SpellBooks;
import net.spell_engine.api.spell.container.SpellContainer;
import net.tiny_config.ConfigManager;

public class ArchersMod {
    public static final String ID = "archers";
    public static ConfigManager<ArchersItemConfig> itemConfig = new ConfigManager("equipment", (Object)Default.itemConfig).builder().setDirectory("archers").sanitize(true).build();
    public static ConfigManager<ConfigFile.Effects> effectsConfig = new ConfigManager("effects", (Object)new ConfigFile.Effects()).builder().setDirectory("archers").sanitize(true).build();
    public static ConfigManager<StructurePoolConfig> villagesConfig = new ConfigManager("villages", (Object)Default.villages).builder().setDirectory("archers").sanitize(true).build();
    public static ConfigManager<TweaksConfig> tweaksConfig = new ConfigManager("tweaks", (Object)new TweaksConfig()).builder().setDirectory("archers").sanitize(true).build();

    public static void init() {
        tweaksConfig.refresh();
        itemConfig.refresh();
        effectsConfig.refresh();
        villagesConfig.refresh();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            ((TweaksConfig)ArchersMod.tweaksConfig.value).ignore_items_required_mods = true;
        }
        if (!FabricLoader.getInstance().isModLoaded("lithostitched")) {
            StructurePoolAPI.injectAll((StructurePoolConfig)((StructurePoolConfig)ArchersMod.villagesConfig.value));
        }
        if (((TweaksConfig)ArchersMod.tweaksConfig.value).enable_infinity_for_crossbows) {
            EnchantmentEvents.ALLOW_ENCHANTING.register((enchantment, target, enchantingContext) -> {
                if (target.getItem() instanceof CrossbowItem && ((ResourceKey)enchantment.unwrapKey().get()).location().equals((Object)Enchantments.INFINITY.location())) {
                    return TriState.TRUE;
                }
                return TriState.DEFAULT;
            });
        }
    }

    public static void registerSounds() {
        ArcherSounds.register();
    }

    public static void registerBlocks() {
        ArcherBlocks.register();
    }

    public static void registerItems() {
        Group.ARCHERS = FabricItemGroup.builder().icon(() -> new ItemStack((ItemLike)ArcherArmors.archerArmorSet_T2.head)).title((Component)Component.translatable((String)"itemGroup.archers.general")).build();
        Registry.register((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, Group.KEY, (Object)Group.ARCHERS);
        SpellBooks.createAndRegister((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ID, (String)"archer"), (SpellContainer.ContentType)SpellContainer.ContentType.ARCHERY, Group.KEY);
        Misc.register();
        ArcherWeapons.register(((ArchersItemConfig)ArchersMod.itemConfig.value).ranged_weapons, ((ArchersItemConfig)ArchersMod.itemConfig.value).melee_weapons);
        ArcherArmors.register(((ArchersItemConfig)ArchersMod.itemConfig.value).armor_sets);
        itemConfig.save();
    }

    public static void registerEffects() {
        ArcherEffects.register((ConfigFile.Effects)ArchersMod.effectsConfig.value);
        effectsConfig.save();
    }

    public static void registerPOI() {
        ArcherVillagers.registerPOI();
    }

    public static void registerVillagers() {
        ArcherVillagers.registerVillagers();
    }
}

