/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.SlotGroupImpl;
import io.wispforest.accessories.impl.SlotTypeImpl;
import io.wispforest.accessories.utils.CollectionUtils;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public record SyncData(List<SlotType> slotTypes, Map<EntityType<?>, List<String>> entitySlots, List<SlotGroup> slotGroups, List<String> uniqueGroups, Map<String, ExtraSlotTypeProperties> uniqueExtraProperties) {
    private static final Endec<Map<EntityType<?>, List<String>>> ENTITY_SLOTS_ENDEC = EndecUtils.map(LinkedHashMap::new, type -> BuiltInRegistries.ENTITY_TYPE.getKey(type).toString(), s -> (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)s)), Endec.STRING.listOf());
    public static StructEndec<SyncData> ENDEC = StructEndecBuilder.of((StructField)SlotTypeImpl.ENDEC.listOf().fieldOf("slotTypes", SyncData::slotTypes), (StructField)ENTITY_SLOTS_ENDEC.fieldOf("entitySlots", SyncData::entitySlots), (StructField)SlotGroupImpl.ENDEC.listOf().fieldOf("slotGroups", SyncData::slotGroups), (StructField)Endec.STRING.listOf().fieldOf("uniqueGroups", SyncData::uniqueGroups), (StructField)ExtraSlotTypeProperties.ENDEC.mapOf().fieldOf("uniqueExtraProperties", SyncData::uniqueExtraProperties), SyncData::new);

    public static SyncData create() {
        Map<String, SlotType> allSlotTypes = SlotTypeLoader.INSTANCE.getSlotTypes(false);
        LinkedHashMap entitySlots = new LinkedHashMap();
        for (Map.Entry<EntityType<?>, Map<String, SlotType>> entry : EntitySlotLoader.INSTANCE.getEntitySlotData(false).entrySet()) {
            entitySlots.put(entry.getKey(), List.copyOf(entry.getValue().keySet()));
        }
        List<SlotGroup> slotGroups = SlotGroupLoader.INSTANCE.getGroups(false, false);
        return new SyncData(List.copyOf(allSlotTypes.values()), entitySlots, slotGroups, List.copyOf(UniqueSlotHandling.getGroups(false)), ExtraSlotTypeProperties.getProperties(false));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handlePacket(SyncData packet, Player player) {
        LinkedHashMap<String, SlotType> slotTypes = new LinkedHashMap<String, SlotType>();
        for (SlotType slotType : packet.slotTypes()) {
            slotTypes.put(slotType.name(), slotType);
        }
        SlotTypeLoader.INSTANCE.setSlotType(slotTypes);
        UniqueSlotHandling.buildClientSlotReferences();
        LinkedHashMap entitySlotTypes = new LinkedHashMap();
        for (Map.Entry<EntityType<?>, List<String>> entry : packet.entitySlots().entrySet()) {
            LinkedHashMap<String, SlotType> map = entry.getValue().stream().map(slotTypes::get).collect(CollectionUtils.toLinkedMap(SlotType::name));
            entitySlotTypes.put(entry.getKey(), map);
        }
        EntitySlotLoader.INSTANCE.setEntitySlotData(entitySlotTypes);
        LinkedHashMap<String, SlotGroup> linkedHashMap = packet.slotGroups().stream().collect(CollectionUtils.toLinkedMap(SlotGroup::name));
        SlotGroupLoader.INSTANCE.setGroups(linkedHashMap);
        UniqueSlotHandling.setClientGroups(packet.uniqueGroups());
        ExtraSlotTypeProperties.setClientPropertyMap(packet.uniqueExtraProperties());
    }
}

