/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin.client;

import io.wispforest.accessories.client.gui.components.ComponentUtils;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.accessories.networking.server.NukeAccessories;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CreativeModeInventoryScreen.class})
public abstract class CreativeInventoryScreenMixin
extends EffectRenderingInventoryScreen<CreativeModeInventoryScreen.ItemPickerMenu>
implements ComponentUtils.CreativeScreenExtension {
    @Shadow
    private static CreativeModeTab selectedTab;
    @Unique
    private int nukeCoolDown = 0;
    @Unique
    private final Event<ComponentUtils.OnCreativeTabChange> onTabChangeEvent = EventFactory.createArrayBacked(ComponentUtils.OnCreativeTabChange.class, invokers -> tab -> {
        for (ComponentUtils.OnCreativeTabChange invoker : invokers) {
            invoker.onTabChange(tab);
        }
    });

    public CreativeInventoryScreenMixin(CreativeModeInventoryScreen.ItemPickerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    @Inject(method={"containerTick()V"}, at={@At(value="HEAD")})
    private void nukeCooldown(CallbackInfo ci) {
        if (this.nukeCoolDown > 0) {
            --this.nukeCoolDown;
        }
    }

    @Inject(method={"selectTab(Lnet/minecraft/world/item/CreativeModeTab;)V"}, at={@At(value="TAIL")})
    private void adjustAccessoryButton(CreativeModeTab tab, CallbackInfo ci) {
        ((ComponentUtils.OnCreativeTabChange)this.getEvent().invoker()).onTabChange(tab);
    }

    @Inject(method={"slotClicked(Lnet/minecraft/world/inventory/Slot;IILnet/minecraft/world/inventory/ClickType;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/NonNullList;size()I", ordinal=0, shift=At.Shift.BEFORE)})
    private void clearAccessoriesWithClearSlot(Slot slot, int slotId, int mouseButton, ClickType type, CallbackInfo ci) {
        if (this.nukeCoolDown <= 0) {
            AccessoriesNetworking.sendToServer(new NukeAccessories());
            this.nukeCoolDown = 10;
        }
    }

    @Override
    public Event<ComponentUtils.OnCreativeTabChange> getEvent() {
        return this.onTabChangeEvent;
    }

    @Override
    public CreativeModeTab getTab() {
        return selectedTab;
    }
}

