/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.menu.variants;

import com.mojang.datafixers.util.Pair;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.menu.AccessoriesBasedSlot;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.menu.AccessoriesArmorSlot;
import io.wispforest.accessories.menu.AccessoriesInternalSlot;
import io.wispforest.accessories.menu.AccessoriesMenuData;
import io.wispforest.accessories.menu.AccessoriesMenuTypes;
import io.wispforest.accessories.menu.ArmorSlotTypes;
import io.wispforest.accessories.menu.SlotAccessContainer;
import io.wispforest.accessories.menu.SlotTypeAccessible;
import io.wispforest.accessories.menu.networking.ToggledSlots;
import io.wispforest.accessories.menu.variants.AccessoriesMenuBase;
import io.wispforest.owo.client.screens.SlotGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SaddleItem;
import org.jetbrains.annotations.Nullable;

public class AccessoriesExperimentalMenu
extends AccessoriesMenuBase {
    private final Set<SlotType> usedSlots = new HashSet<SlotType>();
    private final Set<SlotGroup> selectedGroups = new HashSet<SlotGroup>();
    private final List<AccessoriesBasedSlot> accessoriesSpecificSlots = new ArrayList<AccessoriesBasedSlot>();
    private int addedArmorSlots = 0;
    private int startArmorSlots = 0;
    private int startingAccessoriesSlot = 0;
    private boolean includeSaddle = false;

    public static AccessoriesExperimentalMenu of(int containerId, Inventory inventory, AccessoriesMenuData data) {
        LivingEntity targetEntity = data.targetEntityId().map(i -> {
            LivingEntity livingEntity;
            Entity patt0$temp = inventory.player.level().getEntity(i.intValue());
            return patt0$temp instanceof LivingEntity ? (livingEntity = (LivingEntity)patt0$temp) : null;
        }).orElse(null);
        AccessoriesMenuBase menu = new AccessoriesExperimentalMenu(containerId, inventory, targetEntity).isSyncedWithServer(data.slotAmountAdded());
        return (AccessoriesExperimentalMenu)menu;
    }

    public AccessoriesExperimentalMenu(int containerId, final Inventory inventory, @Nullable LivingEntity targetEntity) {
        super(AccessoriesMenuTypes.EXPERIMENTAL_MENU, containerId, inventory, targetEntity);
        LivingEntity accessoryTarget = targetEntity != null ? targetEntity : this.owner;
        AccessoriesCapability capability = AccessoriesCapability.get(accessoryTarget);
        if (capability == null) {
            return;
        }
        this.updateUsedSlots();
        SlotGenerator.begin(x$0 -> this.addSlot((Slot)x$0), (int)-300, (int)-300).playerInventory(inventory);
        this.addSlot(new Slot(this, (Container)inventory, 40, -300, -300){

            public void setByPlayer(ItemStack itemStack, ItemStack itemStack2) {
                inventory.player.onEquipItem(EquipmentSlot.OFFHAND, itemStack2, itemStack);
                super.setByPlayer(itemStack, itemStack2);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        Container saddleInv = SlotAccessContainer.ofSaddleSlot(accessoryTarget);
        if (saddleInv != null) {
            this.includeSaddle = true;
            final String iconPath = targetEntity instanceof Llama ? "container/horse/llama_armor_slot" : "container/horse/saddle_slot";
            this.addSlot(new Slot(this, saddleInv, 0, -300, -300){

                public boolean mayPlace(ItemStack stack) {
                    return stack.getItem() instanceof SaddleItem && super.mayPlace(stack);
                }

                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)ArmorSlotTypes.SPRITE_ATLAS_LOCATION, (Object)ResourceLocation.withDefaultNamespace((String)iconPath));
                }
            });
        }
        this.startArmorSlots = this.slots.size();
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        ArrayList<EquipmentSlot> validEquipmentSlots = new ArrayList<EquipmentSlot>();
        for (EquipmentSlot value : EquipmentSlot.values()) {
            SlotTypeReference armorRef;
            if (!accessoryTarget.canUseSlot(value) || (armorRef = ArmorSlotTypes.getReferenceFromSlot(value)) == null || containers.get(armorRef.slotName()) == null) continue;
            validEquipmentSlots.add(value);
        }
        for (EquipmentSlot equipmentSlot : validEquipmentSlots.reversed()) {
            if (!this.addArmorSlot(equipmentSlot, accessoryTarget, ArmorSlotTypes.getReferenceFromSlot(equipmentSlot), containers)) continue;
            this.addedArmorSlots += 2;
        }
        this.startingAccessoriesSlot = this.slots.size();
        Map<SlotGroup, List<SlotType>> validGroupData = SlotGroupLoader.getValidGroups(accessoryTarget);
        List slotTypes = validGroupData.values().stream().flatMap(Collection::stream).toList();
        for (SlotType slot : slotTypes) {
            AccessoriesContainer accessoryContainer = containers.get(slot.name());
            if (accessoryContainer == null || accessoryContainer.slotType() == null) continue;
            for (int i = 0; i < accessoryContainer.getSize(); ++i) {
                AccessoriesInternalSlot cosmeticSlot = new AccessoriesInternalSlot(accessoryContainer, true, i, -300, -300).useCosmeticIcon(false);
                this.addSlot(cosmeticSlot);
                this.accessoriesSpecificSlots.add(cosmeticSlot);
                AccessoriesInternalSlot baseSlot = new AccessoriesInternalSlot(accessoryContainer, false, i, -300, -300);
                this.addSlot(baseSlot);
                this.accessoriesSpecificSlots.add(baseSlot);
            }
        }
        ToggledSlots.initMenu((AbstractContainerMenu)this);
        this.slotAmountAdded = this.slots.size() - this.startArmorSlots;
    }

    private boolean addArmorSlot(EquipmentSlot equipmentSlot, LivingEntity targetEntity, SlotTypeReference armorReference, Map<String, AccessoriesContainer> containers) {
        final it.unimi.dsi.fastutil.Pair<ResourceLocation, ResourceLocation> location = ArmorSlotTypes.getEmptyTexture(equipmentSlot, targetEntity);
        AccessoriesContainer armorContainer = containers.get(armorReference.slotName());
        if (armorContainer == null) {
            return false;
        }
        ArmorSlot armorSlot = new AccessoriesArmorSlot(armorContainer, SlotAccessContainer.ofArmor(equipmentSlot, targetEntity), targetEntity, equipmentSlot, 0, -300, -300, location != null ? (ResourceLocation)location.second() : null).setAtlasLocation(location != null ? (ResourceLocation)location.first() : null);
        this.addSlot((Slot)armorSlot);
        AccessoriesInternalSlot cosmeticSlot = new AccessoriesInternalSlot(this, armorContainer, true, 0, -300, -300){

            @Override
            @Nullable
            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                if (location == null) {
                    return null;
                }
                ResourceLocation atlasLocation = (ResourceLocation)location.first();
                if (atlasLocation == null) {
                    atlasLocation = ResourceLocation.withDefaultNamespace((String)"textures/atlas/blocks.png");
                }
                return Pair.of((Object)atlasLocation, (Object)((ResourceLocation)location.second()));
            }
        };
        this.addSlot(cosmeticSlot);
        return true;
    }

    public final LivingEntity targetEntityDefaulted() {
        LivingEntity targetEntity = this.targetEntity();
        return targetEntity != null ? targetEntity : this.owner();
    }

    public int startingAccessoriesSlot() {
        return this.startArmorSlots;
    }

    public List<AccessoriesBasedSlot> getAccessoriesSlots() {
        return this.accessoriesSpecificSlots;
    }

    public List<Slot> getVisibleAccessoriesSlots() {
        ArrayList<Slot> filteredList = new ArrayList<Slot>();
        Map<SlotGroup, List<SlotType>> groups = SlotGroupLoader.getValidGroups(this.targetEntityDefaulted());
        Set<SlotType> usedSlots = this.getUsedSlots();
        if (usedSlots != null) {
            groups.forEach((group, groupSlots) -> {
                if (groupSlots.stream().noneMatch(usedSlots::contains)) {
                    this.removeSelectedGroup((SlotGroup)group);
                }
            });
        }
        List selectedGroupedSlots = SlotGroupLoader.getValidGroups(this.targetEntityDefaulted()).entrySet().stream().filter(entry -> this.selectedGroups.isEmpty() || this.selectedGroups.contains(entry.getKey())).flatMap(entry -> ((List)entry.getValue()).stream()).toList();
        for (int i = 0; i < this.accessoriesSpecificSlots.size() / 2; ++i) {
            boolean isVisible;
            int cosmetic = i * 2;
            int accessory = cosmetic + 1;
            AccessoriesBasedSlot cosmeticSlot = this.accessoriesSpecificSlots.get(cosmetic);
            AccessoriesBasedSlot accessorySlot = this.accessoriesSpecificSlots.get(accessory);
            SlotType slotType = accessorySlot.slotType();
            boolean bl = isVisible = !(!this.usedSlots.isEmpty() && !this.usedSlots.contains(slotType) || !selectedGroupedSlots.isEmpty() && !selectedGroupedSlots.contains(slotType));
            if (!isVisible) continue;
            filteredList.add(cosmeticSlot);
            filteredList.add(accessorySlot);
        }
        return filteredList;
    }

    @Nullable
    public Set<SlotType> getUsedSlots() {
        return this.areUnusedSlotsShown() ? null : this.usedSlots;
    }

    public void updateUsedSlots() {
        this.usedSlots.clear();
        if (!this.areUnusedSlotsShown()) {
            Collection<SlotType> currentlyUsedSlots = AccessoriesAPI.getUsedSlotsFor((LivingEntity)(this.targetEntity != null ? this.targetEntity : this.owner), (Container)this.owner.getInventory());
            if (!currentlyUsedSlots.isEmpty()) {
                this.usedSlots.addAll(currentlyUsedSlots);
            } else {
                this.usedSlots.add(null);
            }
        }
    }

    public Set<SlotGroup> usedGroups() {
        Stream<Object> groups = SlotGroupLoader.getValidGroups(this.targetEntityDefaulted()).entrySet().stream();
        Set<SlotType> usedSlots = this.getUsedSlots();
        groups = groups.filter(entry -> {
            Set groupSlots = ((List)entry.getValue()).stream().filter(slotType -> {
                if (UniqueSlotHandling.isUniqueSlot(slotType.name())) {
                    return false;
                }
                AccessoriesCapability capability = this.targetEntityDefaulted().accessoriesCapability();
                if (capability == null) {
                    return false;
                }
                AccessoriesContainer container = capability.getContainer((SlotType)slotType);
                if (container == null) {
                    return false;
                }
                return container.getSize() > 0;
            }).collect(Collectors.toSet());
            if (groupSlots.isEmpty()) return false;
            if (usedSlots == null) return true;
            if (!groupSlots.stream().anyMatch(usedSlots::contains)) return false;
            return true;
        });
        return groups.map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<SlotGroup> selectedGroups() {
        return this.selectedGroups;
    }

    public boolean isGroupSelected(SlotGroup slotGroup) {
        return this.selectedGroups.contains(slotGroup);
    }

    public void addSelectedGroup(SlotGroup slotGroup) {
        this.selectedGroups.add(slotGroup);
        if (this.selectedGroups.containsAll(this.usedGroups())) {
            this.selectedGroups.clear();
        }
    }

    public void removeSelectedGroup(SlotGroup slotGroup) {
        this.selectedGroups.remove(slotGroup);
    }

    public int addedArmorSlots() {
        return this.addedArmorSlots;
    }

    public boolean includeSaddle() {
        return this.includeSaddle;
    }

    public boolean areUnusedSlotsShown() {
        return Optional.ofNullable(AccessoriesHolder.get((LivingEntity)this.owner)).map(AccessoriesHolder::showUnusedSlots).orElse(false);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemStack2 = slot.getItem();
        ItemStack itemStack = itemStack2.copy();
        EquipmentSlot equipmentSlot = player.getEquipmentSlotForItem(itemStack);
        int bottomArmorIndex = 42 + (8 - (equipmentSlot.getIndex() + 1) * 2);
        int topArmorIndex = bottomArmorIndex + 1;
        int upperInventorySize = this.startingAccessoriesSlot;
        if (index == 0) {
            if (!this.moveItemStackTo(itemStack2, 5, 41, true)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(itemStack2, itemStack);
        } else if (index >= 1 && index < 5 || index >= upperInventorySize || Objects.equals(41, index) || index >= 43) {
            if (!this.moveItemStackTo(itemStack2, 5, 41, false)) {
                return ItemStack.EMPTY;
            }
        } else if (equipmentSlot.isArmor() && !((Slot)this.slots.get(bottomArmorIndex)).hasItem()) {
            if (!this.moveItemStackTo(itemStack2, bottomArmorIndex, topArmorIndex, false)) {
                return ItemStack.EMPTY;
            }
        } else if (equipmentSlot == EquipmentSlot.OFFHAND && !((Slot)this.slots.get(41)).hasItem()) {
            if (!this.moveItemStackTo(itemStack2, 41, 42, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            boolean changeOccured = false;
            if (this.canMoveToAccessorySlot(itemStack2, this.targetEntityDefaulted())) {
                this.moveItemStackTo(itemStack2, upperInventorySize, this.slots.size(), false);
                if (itemStack2.getCount() != itemStack.getCount() || itemStack2.isEmpty()) {
                    changeOccured = true;
                }
            }
            if (!changeOccured && (index >= 5 && index < 32 ? !this.moveItemStackTo(itemStack2, 32, 41, false) : index >= 32 && index < 41 && !this.moveItemStackTo(itemStack2, 5, 32, false))) {
                return ItemStack.EMPTY;
            }
        }
        if (itemStack2.getCount() == itemStack.getCount()) {
            return ItemStack.EMPTY;
        }
        if (itemStack2.isEmpty()) {
            slot.setByPlayer(ItemStack.EMPTY, itemStack);
        } else {
            slot.setChanged();
        }
        if (itemStack2.getCount() == itemStack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, itemStack2);
        if (index == 0) {
            player.drop(itemStack2, false);
        }
        return itemStack;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    protected boolean canMoveToAccessorySlot(ItemStack stack, LivingEntity living) {
        AccessoriesCapability capability = living.accessoriesCapability();
        if (capability == null) {
            return false;
        }
        Collection<SlotType> validSlotTypes = AccessoriesAPI.getStackSlotTypes(living, stack);
        for (Slot slot : this.slots.subList(this.startingAccessoriesSlot, this.slots.size())) {
            SlotTypeAccessible accessible;
            if (!(slot instanceof SlotTypeAccessible) || !validSlotTypes.contains((accessible = (SlotTypeAccessible)slot).slotType())) continue;
            return true;
        }
        return false;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        int j;
        ItemStack itemStack;
        Slot slot;
        int i;
        boolean bl = false;
        int n = i = reverseDirection ? endIndex - 1 : startIndex;
        if (stack.isStackable()) {
            while (!stack.isEmpty() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                slot = (Slot)this.slots.get(i);
                if (slot.isActive() && !(itemStack = slot.getItem()).isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack)) {
                    int k;
                    j = itemStack.getCount() + stack.getCount();
                    if (j <= (k = slot.getMaxStackSize(itemStack))) {
                        stack.setCount(0);
                        itemStack.setCount(j);
                        slot.setChanged();
                        bl = true;
                    } else if (itemStack.getCount() < k) {
                        stack.shrink(k - itemStack.getCount());
                        itemStack.setCount(k);
                        slot.setChanged();
                        bl = true;
                    }
                }
                i += reverseDirection ? -1 : 1;
            }
        }
        if (!stack.isEmpty()) {
            int n2 = i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                slot = (Slot)this.slots.get(i);
                if (slot.isActive() && (itemStack = slot.getItem()).isEmpty() && slot.mayPlace(stack)) {
                    j = slot.getMaxStackSize(stack);
                    slot.setByPlayer(stack.split(Math.min(stack.getCount(), j)));
                    slot.setChanged();
                    bl = true;
                    break;
                }
                i += reverseDirection ? -1 : 1;
            }
        }
        return bl;
    }

    @Override
    public void initializeContents(int stateId, List<ItemStack> items, ItemStack carried) {
        if (!this.isValidMenu()) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            Slot slot = this.getSlot(i);
            if (slot instanceof SlotTypeAccessible) continue;
            slot.set(items.get(i));
        }
        super.initializeContents(stateId, List.of(), carried);
    }
}

