/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.menu;

import io.wispforest.accessories.menu.SlotAccessContainer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public interface EquipmentSlotBasedContainer
extends Container {
    public static Container of(EquipmentSlot equipmentSlot, LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return EquipmentSlotBasedContainer.ofPlayer(equipmentSlot, player);
        }
        return EquipmentSlotBasedContainer.ofLiving(equipmentSlot, livingEntity);
    }

    public static Container ofLiving(EquipmentSlot equipmentSlot, LivingEntity livingEntity) {
        SlotAccess slotAccess = SlotAccess.of(() -> livingEntity.getItemBySlot(equipmentSlot), (T stack) -> livingEntity.setItemSlot(equipmentSlot, stack));
        return new SlotAccessContainer(slotAccess);
    }

    public static Container ofPlayer(EquipmentSlot equipmentSlot, Player player) {
        SlotAccess slotAccess = SlotAccess.of(() -> {
            int index;
            Inventory inv = player.getInventory();
            switch (equipmentSlot) {
                case HEAD: {
                    int n = 3;
                    break;
                }
                case CHEST: {
                    int n = 2;
                    break;
                }
                case LEGS: {
                    int n = 1;
                    break;
                }
                case FEET: {
                    int n = 0;
                    break;
                }
                default: {
                    int n = index = -1;
                }
            }
            if (index == -1) {
                return ItemStack.EMPTY;
            }
            return inv.getArmor(index);
        }, (T stack) -> {
            int index;
            Inventory inv = player.getInventory();
            switch (equipmentSlot) {
                case HEAD: {
                    int n = 0;
                    break;
                }
                case CHEST: {
                    int n = 1;
                    break;
                }
                case LEGS: {
                    int n = 2;
                    break;
                }
                case FEET: {
                    int n = 3;
                    break;
                }
                default: {
                    int n = index = -1;
                }
            }
            if (index == -1) {
                return;
            }
            inv.setItem(39 - index, stack);
        });
        return new SlotAccessContainer(slotAccess);
    }

    public EquipmentSlot equipmentSlot();

    public ItemStack getEquipmentStack(EquipmentSlot var1);

    public void setEquipmentStack(EquipmentSlot var1, ItemStack var2);

    default public int getContainerSize() {
        return 1;
    }

    default public boolean isEmpty() {
        return this.getItem(0).isEmpty();
    }

    default public ItemStack getItem(int slot) {
        return this.getEquipmentStack(this.equipmentSlot());
    }

    default public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = this.getItem(0).copy();
        ItemStack removedStack = stack.split(amount);
        this.setEquipmentStack(this.equipmentSlot(), stack);
        return removedStack;
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = this.getItem(0).copy();
        this.setEquipmentStack(this.equipmentSlot(), ItemStack.EMPTY);
        return stack;
    }

    default public void setItem(int slot, ItemStack stack) {
        this.setEquipmentStack(this.equipmentSlot(), stack);
    }

    default public void setChanged() {
    }

    default public boolean stillValid(Player player) {
        return true;
    }

    default public void clearContent() {
    }
}

