/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryNest;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessoryNestContainerContents;
import io.wispforest.accessories.api.slot.NestedSlotReferenceImpl;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AccessoryNestUtils {
    @Nullable
    public static AccessoryNestContainerContents getData(ItemStack stack) {
        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack);
        if (!(accessory instanceof AccessoryNest)) {
            return null;
        }
        return (AccessoryNestContainerContents)stack.get(AccessoriesDataComponents.NESTED_ACCESSORIES);
    }

    @Nullable
    public static <T> T recursiveStackHandling(ItemStack stack, SlotReference reference, BiFunction<ItemStack, SlotReference, @Nullable T> function) {
        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack);
        T value = function.apply(stack, reference);
        if (accessory instanceof AccessoryNest) {
            AccessoryNest holdable = (AccessoryNest)accessory;
            if (value == null) {
                List<ItemStack> innerStacks = holdable.getInnerStacks(stack);
                for (int i = 0; i < innerStacks.size(); ++i) {
                    ItemStack innerStack = innerStacks.get(i);
                    if (innerStack.isEmpty() || (value = AccessoryNestUtils.recursiveStackHandling(innerStack, AccessoryNestUtils.create(reference, i), function)) == null) continue;
                    return value;
                }
            }
        }
        return value;
    }

    public static void recursiveStackConsumption(ItemStack stack, SlotReference reference, BiConsumer<ItemStack, SlotReference> consumer) {
        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(stack);
        consumer.accept(stack, reference);
        if (!(accessory instanceof AccessoryNest)) {
            return;
        }
        AccessoryNest holdable = (AccessoryNest)accessory;
        List<ItemStack> innerStacks = holdable.getInnerStacks(stack);
        for (int i = 0; i < innerStacks.size(); ++i) {
            ItemStack innerStack = innerStacks.get(i);
            if (innerStack.isEmpty()) continue;
            AccessoryNestUtils.recursiveStackConsumption(innerStack, AccessoryNestUtils.create(reference, i), consumer);
        }
    }

    public static SlotReference create(SlotReference reference, int innerIndex) {
        ArrayList<Integer> innerSlotIndices = new ArrayList<Integer>();
        if (reference instanceof NestedSlotReferenceImpl) {
            NestedSlotReferenceImpl nestedSlotReference = (NestedSlotReferenceImpl)reference;
            innerSlotIndices.addAll(nestedSlotReference.innerSlotIndices());
        }
        innerSlotIndices.add(innerIndex);
        return SlotReference.ofNest(reference.entity(), reference.slotName(), reference.slot(), innerSlotIndices);
    }
}

