/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client.gui.components;

import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.util.ScissorStack;
import java.util.List;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class ExtendedScrollContainer<C extends Component>
extends ScrollContainer<C> {
    protected TriConsumer<ExtendedScrollContainer<?>, Double, Double> scrolledTo = (container, prevOffset, currentOffset) -> {};
    protected boolean oppositeScrollbar = false;
    protected boolean strictMouseScrolling = false;
    private Insets customClippingInsets = Insets.none();
    @Nullable
    public Runnable scrollToAfterLayout = null;

    public ExtendedScrollContainer(ScrollContainer.ScrollDirection direction, Sizing horizontalSizing, Sizing verticalSizing, C child) {
        super(direction, horizontalSizing, verticalSizing, child);
    }

    public double getProgress() {
        return this.scrollOffset / (double)this.maxScroll;
    }

    public ExtendedScrollContainer<C> scrollToAfterLayout(double progress) {
        this.scrollToAfterLayout = () -> {
            this.scrollOffset = (double)this.maxScroll * Math.clamp(progress, 0.0, 1.0);
        };
        return this;
    }

    public void layout(Size space) {
        super.layout(space);
        if (this.scrollToAfterLayout != null) {
            this.scrollToAfterLayout.run();
            this.scrollToAfterLayout = null;
        }
    }

    public ExtendedScrollContainer<C> customClippingInsets(Insets insets) {
        this.customClippingInsets = insets;
        return this;
    }

    public ExtendedScrollContainer<C> oppositeScrollbar(boolean value) {
        this.oppositeScrollbar = value;
        return this;
    }

    public boolean oppositeScrollbar() {
        return this.oppositeScrollbar;
    }

    public ExtendedScrollContainer<C> strictMouseScrolling(boolean value) {
        this.strictMouseScrolling = value;
        return this;
    }

    protected boolean isInScrollbar(double mouseX, double mouseY) {
        if (this.oppositeScrollbar) {
            return this.isInBoundingBox(mouseX, mouseY) && this.direction.choose(mouseY, mouseX) <= (double)(this.x + this.scrollbarThiccness);
        }
        return super.isInScrollbar(mouseX, mouseY);
    }

    protected Size calculateChildSpace(Size thisSpace) {
        Insets padding = (Insets)this.padding.get();
        return Size.of((int)Mth.lerpInt((float)((Sizing)this.horizontalSizing.get()).contentFactor(), (int)(this.width - padding.horizontal() - this.horizontalScrollbarOffset()), (int)(thisSpace.width() - padding.horizontal())), (int)Mth.lerpInt((float)((Sizing)this.verticalSizing.get()).contentFactor(), (int)(this.height - padding.vertical() - this.verticalScrollbarOffset()), (int)(thisSpace.height() - padding.vertical())));
    }

    protected int childMountX() {
        return super.childMountX() + this.horizontalScrollbarOffset();
    }

    protected int childMountY() {
        return super.childMountY() + this.verticalScrollbarOffset();
    }

    private int horizontalScrollbarOffset() {
        return this.oppositeScrollbar && this.direction == ScrollContainer.ScrollDirection.VERTICAL ? this.scrollbarThiccness : 0;
    }

    private int verticalScrollbarOffset() {
        return this.oppositeScrollbar && this.direction == ScrollContainer.ScrollDirection.HORIZONTAL ? this.scrollbarThiccness : 0;
    }

    public double currentScrollOffset() {
        return this.scrollOffset;
    }

    public ExtendedScrollContainer<C> scrollTo(double scrollOffset) {
        this.scrollOffset = Mth.clamp((double)scrollOffset, (double)0.0, (double)this.maxScroll);
        return this;
    }

    public ExtendedScrollContainer<C> scrolledToCallback(TriConsumer<ExtendedScrollContainer<?>, Double, Double> consumer) {
        this.scrolledTo = consumer;
        return this;
    }

    protected void scrollBy(double offset, boolean instant, boolean showScrollbar) {
        double prevOffset = this.scrollOffset;
        super.scrollBy(offset, instant, showScrollbar);
        this.scrolledTo.accept((Object)this, (Object)prevOffset, (Object)this.scrollOffset);
    }

    public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
        if (this.strictMouseScrolling && !this.isInScrollbar((double)this.x + mouseX, (double)this.y + mouseY)) {
            return false;
        }
        return super.onMouseScroll(mouseX, mouseY, amount);
    }

    protected void drawChildren(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta, List<? extends Component> children) {
        if (this.customClippingInsets != Insets.none()) {
            ScissorStack.push((int)(this.x + this.customClippingInsets.left()), (int)(this.y + this.customClippingInsets.top()), (int)(this.width - this.customClippingInsets.horizontal()), (int)(this.height - this.customClippingInsets.vertical()), (PoseStack)context.pose());
        }
        super.drawChildren(context, mouseX, mouseY, partialTicks, delta, children);
        if (this.customClippingInsets != Insets.none()) {
            ScissorStack.pop();
        }
    }
}

