/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.slot;

import com.google.common.collect.Lists;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryNest;
import io.wispforest.accessories.api.slot.SlotReference;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record NestedSlotReferenceImpl(LivingEntity entity, String slotName, int initialHolderSlot, List<Integer> innerSlotIndices) implements SlotReference
{
    public NestedSlotReferenceImpl {
        if (initialHolderSlot < -1) {
            throw new IndexOutOfBoundsException("A given Nested Slot Reference was attempted to be created with a negative initialHolderSlot value!");
        }
    }

    @Override
    public String createSlotPath() {
        StringBuilder slotPath = new StringBuilder(SlotReference.super.createSlotPath());
        List<Integer> innerSlotIndices = this.innerSlotIndices();
        for (int i = 0; i < innerSlotIndices.size(); ++i) {
            Integer innerIndex = innerSlotIndices.get(i);
            slotPath.append("/nest_").append(i).append("_").append(innerIndex);
        }
        return slotPath.toString();
    }

    @Override
    public boolean isValid() {
        if (!SlotReference.super.isValid()) {
            return false;
        }
        ItemStack selectedStack = SlotReference.super.getStack();
        for (Integer innerSlotIndex : this.innerSlotIndices()) {
            Pair<NestLayer, ItemStack> innerData = NestedSlotReferenceImpl.tryAndGet(selectedStack, innerSlotIndex);
            if (innerData == null) {
                return false;
            }
            selectedStack = (ItemStack)innerData.right();
        }
        return true;
    }

    @Override
    public int slot() {
        return this.initialHolderSlot();
    }

    @Override
    @Nullable
    public ItemStack getStack() {
        ItemStack selectedStack = SlotReference.super.getStack();
        for (Integer innerSlotIndex : this.innerSlotIndices()) {
            Pair<NestLayer, ItemStack> innerData = NestedSlotReferenceImpl.tryAndGet(selectedStack, innerSlotIndex);
            if (innerData == null) {
                return null;
            }
            selectedStack = (ItemStack)innerData.right();
        }
        return selectedStack;
    }

    @Nullable
    private static Pair<NestLayer, ItemStack> tryAndGet(ItemStack holderStack, int innerIndex) {
        Accessory accessory = AccessoriesAPI.getOrDefaultAccessory(holderStack);
        if (!(accessory instanceof AccessoryNest)) {
            return null;
        }
        AccessoryNest accessoryNest = (AccessoryNest)accessory;
        return Pair.of((Object)new NestLayer(accessoryNest, holderStack, innerIndex), (Object)accessoryNest.getInnerStacks(holderStack).get(innerIndex));
    }

    @Override
    public boolean setStack(ItemStack stack) {
        ItemStack selectedStack = SlotReference.super.getStack();
        if (selectedStack == null) {
            return false;
        }
        ArrayList<NestLayer> layerStack = new ArrayList<NestLayer>();
        for (Integer innerSlotIndex : this.innerSlotIndices()) {
            Pair<NestLayer, ItemStack> innerData = NestedSlotReferenceImpl.tryAndGet(selectedStack, innerSlotIndex);
            if (innerData == null) {
                return false;
            }
            layerStack.add((NestLayer)innerData.first());
            selectedStack = (ItemStack)innerData.right();
        }
        ItemStack innerStack = stack;
        for (NestLayer layer : Lists.reverse(layerStack)) {
            if (!layer.setStack(innerStack)) {
                return false;
            }
            innerStack = layer.holderStack();
        }
        SlotReference.super.setStack(innerStack);
        return true;
    }

    private record NestLayer(AccessoryNest accessoryNest, ItemStack holderStack, int index) {
        private boolean setStack(ItemStack innerStack) {
            return this.accessoryNest.setInnerStack(this.holderStack, this.index, innerStack);
        }
    }
}

