/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import io.wispforest.accessories.api.client.Side;
import io.wispforest.accessories.mixin.client.ModelPartAccessor;
import io.wispforest.accessories.pond.ModelRootAccess;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ModelTransformUtils {
    private static final Map<ResourceLocation, ModelPartTransformer> ADDITIONAL_TRANSFORMERS = new LinkedHashMap<ResourceLocation, ModelPartTransformer>();

    @ApiStatus.Experimental
    public static void registerTransformer(ResourceLocation location, ModelPartTransformer modelTransformers) {
        if (ADDITIONAL_TRANSFORMERS.containsKey(location)) {
            throw new IllegalStateException("Already existing ModelTransformer exists!");
        }
        ADDITIONAL_TRANSFORMERS.put(location, modelTransformers);
    }

    @ApiStatus.Experimental
    public static boolean transformToFace(PoseStack poseStack, LivingEntity livingEntity, Model model, String modelPartName, Side side) {
        return ModelTransformUtils.transformToModelPart(poseStack, livingEntity, model, modelPartName, side.direction.getNormal().getX(), side.direction.getNormal().getY(), side.direction.getNormal().getZ());
    }

    @ApiStatus.Experimental
    public static boolean transformToModelPart(PoseStack poseStack, LivingEntity livingEntity, Model model, String modelPartName) {
        return ModelTransformUtils.transformToModelPart(poseStack, livingEntity, model, modelPartName, 0, 0, 0);
    }

    @ApiStatus.Experimental
    public static boolean transformToModelPart(PoseStack poseStack, LivingEntity livingEntity, Model model, String modelPartName, @Nullable Number xPercent, @Nullable Number yPercent, @Nullable Number zPercent) {
        for (Map.Entry<ResourceLocation, ModelPartTransformer> entry : ADDITIONAL_TRANSFORMERS.entrySet()) {
            boolean result = entry.getValue().transformToPart(poseStack, livingEntity, model, modelPartName, xPercent, yPercent, zPercent);
            if (!result) continue;
            return true;
        }
        ModelPart modelPart = ModelTransformUtils.getPart(model, modelPartName);
        if (modelPart != null) {
            ModelTransformUtils.transformToModelPart(poseStack, modelPart, xPercent, yPercent, zPercent);
            return true;
        }
        return false;
    }

    @ApiStatus.Experimental
    @Nullable
    public static ModelPart getPart(Model model, String modelPartName) {
        ModelRootAccess access;
        Optional<ModelPart> possiblePart;
        if (model instanceof ModelRootAccess && (possiblePart = (access = (ModelRootAccess)model).accessories$getAnyDescendantWithName(modelPartName)).isPresent()) {
            return possiblePart.get();
        }
        return null;
    }

    public static void transformToFace(PoseStack poseStack, ModelPart part, Side side) {
        ModelTransformUtils.transformToModelPart(poseStack, part, side.direction.getNormal().getX(), side.direction.getNormal().getY(), side.direction.getNormal().getZ());
    }

    public static void transformToModelPart(PoseStack poseStack, ModelPart part) {
        ModelTransformUtils.transformToModelPart(poseStack, part, 0, 0, 0);
    }

    public static void transformToModelPart(PoseStack poseStack, ModelPart part, @Nullable Number xPercent, @Nullable Number yPercent, @Nullable Number zPercent) {
        part.translateAndRotate(poseStack);
        Pair<Vec3, Vec3> aabb = ModelTransformUtils.getAABB(part);
        poseStack.scale(0.0625f, 0.0625f, 0.0625f);
        poseStack.translate(xPercent != null ? Mth.lerp((double)((-xPercent.doubleValue() + 1.0) / 2.0), (double)((Vec3)aabb.getFirst()).x, (double)((Vec3)aabb.getSecond()).x) : 0.0, yPercent != null ? Mth.lerp((double)((-yPercent.doubleValue() + 1.0) / 2.0), (double)((Vec3)aabb.getFirst()).y, (double)((Vec3)aabb.getSecond()).y) : 0.0, zPercent != null ? Mth.lerp((double)((-zPercent.doubleValue() + 1.0) / 2.0), (double)((Vec3)aabb.getFirst()).z, (double)((Vec3)aabb.getSecond()).z) : 0.0);
        poseStack.scale(8.0f, 8.0f, 8.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
    }

    private static Pair<Vec3, Vec3> getAABB(ModelPart part) {
        Vec3 min = new Vec3(0.0, 0.0, 0.0);
        Vec3 max = new Vec3(0.0, 0.0, 0.0);
        if (part.getClass().getSimpleName().contains("EMFModelPart")) {
            ArrayList<ModelPart> parts = new ArrayList<ModelPart>();
            parts.add(part);
            parts.addAll(((ModelPartAccessor)part).getChildren().values());
            for (ModelPart modelPart : parts) {
                for (ModelPart.Cube cube : ((ModelPartAccessor)modelPart).getCubes()) {
                    min = new Vec3(Math.min(min.x, (double)Math.min(cube.minX + modelPart.x, cube.maxX + modelPart.x)), Math.min(min.y, (double)Math.min(cube.minY + modelPart.y, cube.maxY + modelPart.y)), Math.min(min.z, (double)Math.min(cube.minZ + modelPart.z, cube.maxZ + modelPart.z)));
                    max = new Vec3(Math.max(max.x, (double)Math.max(cube.minX + modelPart.x, cube.maxX + modelPart.x)), Math.max(max.y, (double)Math.max(cube.minY + modelPart.y, cube.maxY + modelPart.y)), Math.max(max.z, (double)Math.max(cube.minZ + modelPart.z, cube.maxZ + modelPart.z)));
                }
            }
        } else {
            for (ModelPart.Cube cube : ((ModelPartAccessor)part).getCubes()) {
                min = new Vec3(Math.min(min.x, (double)Math.min(cube.minX, cube.maxX)), Math.min(min.y, (double)Math.min(cube.minY, cube.maxY)), Math.min(min.z, (double)Math.min(cube.minZ, cube.maxZ)));
                max = new Vec3(Math.max(max.x, (double)Math.max(cube.minX, cube.maxX)), Math.max(max.y, (double)Math.max(cube.minY, cube.maxY)), Math.max(max.z, (double)Math.max(cube.minZ, cube.maxZ)));
            }
        }
        return Pair.of((Object)min, (Object)max);
    }

    @ApiStatus.Experimental
    public static interface ModelPartTransformer {
        public boolean transformToPart(PoseStack var1, LivingEntity var2, Model var3, String var4, @Nullable Number var5, @Nullable Number var6, @Nullable Number var7);
    }
}

