/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.util;

public class StringFormatUtil {
    public static final String[] postfixes = new String[]{"", "K", "M", "B", "T", "Q"};

    public static String formatLong(long l) {
        double number;
        int d = 0;
        for (number = (double)l; number >= 1000.0 && d < postfixes.length; number /= 1000.0, ++d) {
        }
        if (l >= 1000L && Math.floor(number) != number) {
            return String.format("%.1f%s", number, postfixes[d]);
        }
        return (int)number + postfixes[d];
    }

    public static String formatFloat(float f) {
        int d;
        for (d = 0; f >= 1000.0f && d < postfixes.length; f /= 1000.0f, ++d) {
        }
        return String.format("%.1f%s", Float.valueOf(f), postfixes[d]);
    }

    public static String formatPercentFloat(float f) {
        return String.format("%.1f", Float.valueOf(f * 100.0f));
    }
}

