/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.motor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.motor.CreativeMotorBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.antarcticgardens.cna.CNABlockEntityTypes;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.motor.MotorScrollValueBehaviour;
import org.antarcticgardens.cna.content.motor.extension.MotorExtensionBlockEntity;
import org.antarcticgardens.cna.content.motor.variants.IMotorVariant;
import org.antarcticgardens.cna.util.RunnableUtil;
import org.antarcticgardens.cna.util.StringFormatUtil;
import org.antarcticgardens.esl.energy.EnergyStorage;
import org.antarcticgardens.esl.energy.SimpleEnergyStorage;

public class MotorBlockEntity
extends GeneratingKineticBlockEntity
implements IHaveGoggleInformation {
    private final SimpleEnergyStorage storage;
    public boolean needsPower = false;
    private final IMotorVariant variant;
    public MotorScrollValueBehaviour speedBehavior;
    public boolean powered = false;
    private float actualSpeed = 0.0f;
    private float actualStress = 0.0f;
    private long prvEnergy = -100000L;
    private float speed = 0.0f;
    private float stress = 0.0f;
    private long e;

    public MotorBlockEntity(BlockEntityType<?> arg, BlockPos arg2, BlockState arg3, IMotorVariant variant) {
        super(arg, arg2, arg3);
        this.variant = variant;
        this.storage = new SimpleEnergyStorage(variant.getMaxCapacity()).onFinalCommit(RunnableUtil.createBlockEntityUpdater((BlockEntity)this)).setSupportsExtraction(false);
        EnergyStorage.registerForBlockEntity((blockEntity, direction) -> blockEntity.storage, (BlockEntityType)((BlockEntityType)CNABlockEntityTypes.BASIC_MOTOR.get()));
        EnergyStorage.registerForBlockEntity((blockEntity, direction) -> blockEntity.storage, (BlockEntityType)((BlockEntityType)CNABlockEntityTypes.ADVANCED_MOTOR.get()));
        EnergyStorage.registerForBlockEntity((blockEntity, direction) -> blockEntity.storage, (BlockEntityType)((BlockEntityType)CNABlockEntityTypes.REINFORCED_MOTOR.get()));
    }

    public static BlockEntityBuilder.BlockEntityFactory<MotorBlockEntity> create(IMotorVariant variant) {
        return (type, pos, state) -> new MotorBlockEntity(type, pos, state, variant);
    }

    public void initialize() {
        this.powered = this.getLevel().hasNeighborSignal(this.getBlockPos());
        super.initialize();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.speedBehavior = new MotorScrollValueBehaviour((Component)CreateLang.translateDirect((String)"kinetics.creative_motor.rotation_speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new MotorValueBox());
        this.speedBehavior.requiresWrench();
        this.speedBehavior.value = this.getDefaultSpeed();
        this.speedBehavior.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add((BlockEntityBehaviour)this.speedBehavior);
    }

    public int getDefaultSpeed() {
        return 16;
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.storage.setStoredEnergy(compound.getLong("energy"));
        this.actualSpeed = compound.getFloat("aSpeed");
        this.needsPower = compound.getBoolean("needsPower");
        this.stress = compound.getFloat("lastGeneratedStress");
        this.speed = compound.getFloat("lastGeneratedSpeed");
        this.e = compound.getLong("eUse");
        this.actualStress = compound.getFloat("actualStress");
        super.read(compound, registries, clientPacket);
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putLong("energy", this.storage.getStoredEnergy());
        compound.putFloat("aSpeed", this.actualSpeed);
        compound.putBoolean("needsPower", this.needsPower);
        compound.putFloat("lastGeneratedStress", this.stress);
        compound.putFloat("lastGeneratedSpeed", this.speed);
        compound.putFloat("eUse", (float)this.e);
        compound.putFloat("actualStress", this.actualStress);
        super.write(compound, registries, clientPacket);
    }

    public float calculateStressApplied() {
        return 0.0f;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"tooltip.create_new_age.energy_stored", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.energy_storage", (Object[])new Object[]{StringFormatUtil.formatLong(this.storage.getStoredEnergy()), StringFormatUtil.formatLong(this.storage.getCapacity())}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        CreateLang.translate((String)"tooltip.create_new_age.using", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.energy_per_tick", (Object[])new Object[]{StringFormatUtil.formatLong(this.e)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return true;
    }

    public float calculateAddedStressCapacity() {
        if (this.level != null && this.level.isClientSide()) {
            return this.lastCapacityProvided;
        }
        this.lastCapacityProvided = this.actualStress / this.actualSpeed;
        this.lastCapacityProvided = Float.isNaN(this.lastCapacityProvided) || Float.isInfinite(this.lastCapacityProvided) ? 0.0f : Math.abs(this.lastCapacityProvided);
        return this.lastCapacityProvided;
    }

    public float getGeneratedSpeed() {
        return this.actualSpeed;
    }

    public void updateGeneratedRotation() {
        float speed = this.getGeneratedSpeed();
        float prevSpeed = this.speed;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (prevSpeed != speed) {
            IRotate.SpeedLevel levelafter;
            IRotate.SpeedLevel levelBefore;
            if (!this.hasSource() && (levelBefore = IRotate.SpeedLevel.of((float)this.speed)) != (levelafter = IRotate.SpeedLevel.of((float)speed))) {
                this.effects.queueRotationIndicators();
            }
            this.applyNewSpeed(prevSpeed, speed);
        }
        if (this.hasNetwork() && speed != 0.0f) {
            KineticNetwork network = this.getOrCreateNetwork();
            network.updateCapacityFor((KineticBlockEntity)this, this.stress);
            this.notifyStressCapacityChange(this.calculateAddedStressCapacity());
            this.getOrCreateNetwork().updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
            network.updateStress();
        }
        this.onSpeedChanged(prevSpeed);
        this.sendData();
    }

    public void tick() {
        BlockEntity blockEntity;
        super.tick();
        if (this.level == null) {
            return;
        }
        float stressMultiplier = 1.0f;
        long extraEnergy = 0L;
        Direction dir = (Direction)this.getBlockState().getValue((Property)DirectionalKineticBlock.FACING);
        if (this.level.getBlockState(this.getBlockPos().relative(dir.getOpposite())).getOptionalValue((Property)DirectionalKineticBlock.FACING).orElse(dir.getOpposite()) == dir && (blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(dir.getOpposite()))) instanceof MotorExtensionBlockEntity) {
            MotorExtensionBlockEntity extension = (MotorExtensionBlockEntity)blockEntity;
            stressMultiplier = extension.getMultiplier();
            extraEnergy = extension.getVariant().getExtraCapacity();
        }
        this.storage.setCapacity(extraEnergy + this.variant.getMaxCapacity());
        this.speedBehavior.betweenValidated((int)(-this.variant.getSpeed()), (int)this.variant.getSpeed());
        if (!this.level.isClientSide()) {
            int needed = (int)Math.ceil((double)(this.variant.getStress() * stressMultiplier) * (Double)CNAConfig.getCommon().motorSUMultiplier.get() * (Double)CNAConfig.getCommon().suToEnergy.get());
            long l = this.e = this.needsPower == this.powered ? this.storage.internalExtract((long)needed, false) : 0L;
            if (this.e > 0L) {
                this.actualSpeed = this.speedBehavior.value;
                this.actualStress = (float)Math.ceil((double)(this.variant.getStress() * stressMultiplier) * (Double)CNAConfig.getCommon().motorSUMultiplier.get() * (double)((float)this.e / (float)needed));
            } else {
                this.actualSpeed = 0.0f;
                this.actualStress = 0.0f;
            }
            if (this.actualSpeed != this.speed || this.actualStress != this.stress) {
                this.updateGeneratedRotation();
                this.speed = this.actualSpeed;
                this.stress = this.actualStress;
            } else if (this.storage.getStoredEnergy() != this.prvEnergy && this.level.getGameTime() % 20L == 0L) {
                this.sendData();
                this.prvEnergy = this.storage.getStoredEnergy();
            }
        }
    }

    static class MotorValueBox
    extends ValueBoxTransform.Sided {
        MotorValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Direction facing = (Direction)state.getValue((Property)CreativeMotorBlock.FACING);
            return super.getLocalOffset(level, pos, state).add(Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale(-0.0625));
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            super.rotate(level, pos, state, ms);
            Direction facing = (Direction)state.getValue((Property)CreativeMotorBlock.FACING);
            if (facing.getAxis() == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
            TransformStack.of((PoseStack)ms).rotateZDegrees(-AngleHelper.horizontalAngle((Direction)facing) + 180.0f);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.getValue((Property)CreativeMotorBlock.FACING);
            if (facing.getAxis() != Direction.Axis.Y && direction == Direction.DOWN) {
                return false;
            }
            return direction.getAxis() != facing.getAxis();
        }
    }
}

