/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.datagen.recipes.neoforge;

import com.copycatsplus.copycats.config.FeatureToggle;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;

public record FeatureEnabledCondition(ResourceLocation feature, boolean invert) implements ICondition
{
    public static MapCodec<FeatureEnabledCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("feature").forGetter(FeatureEnabledCondition::feature), (App)Codec.BOOL.fieldOf("invert").forGetter(FeatureEnabledCondition::invert)).apply((Applicative)builder, FeatureEnabledCondition::new));

    public FeatureEnabledCondition(ResourceLocation feature) {
        this(feature, false);
    }

    public boolean test(ICondition.IContext context) {
        return FeatureToggle.isEnabled(this.feature) != this.invert;
    }

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }

    @Override
    public String toString() {
        return "FeatureEnabledCondition{feature=" + String.valueOf(this.feature) + ", invert=" + this.invert + "}";
    }
}

