/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.content.copycat.wall;

import com.copycatsplus.copycats.CCBlockEntityTypes;
import com.copycatsplus.copycats.foundation.copycat.CCCopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlock;
import com.copycatsplus.copycats.foundation.copycat.IStateType;
import com.copycatsplus.copycats.utility.InteractionUtils;
import com.simibubi.create.foundation.block.IBE;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopycatWallBlock
extends WallBlock
implements ICopycatBlock,
IBE<CCCopycatBlockEntity>,
IStateType {
    public CopycatWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return true;
    }

    @Nullable
    public <S extends BlockEntity> BlockEntityTicker<S> getTicker(Level level, BlockState state, BlockEntityType<S> type) {
        return null;
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return InteractionUtils.sequential(() -> ICopycatBlock.super.useWithoutItem(state, level, pos, player, hitResult), () -> super.useWithoutItem(state, level, pos, player, hitResult));
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return InteractionUtils.sequentialItem(() -> ICopycatBlock.super.useItemOn(stack, state, level, pos, player, hand, hitResult), () -> super.useItemOn(stack, state, level, pos, player, hand, hitResult));
    }

    @Override
    public boolean isAcceptedRegardless(BlockState material) {
        return material.getBlock() instanceof WallBlock;
    }

    @Override
    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        ICopycatBlock.super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        ICopycatBlock.super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving, (x$0, x$1, x$2, x$3, x$4) -> super.onRemove(x$0, x$1, x$2, x$3, x$4));
    }

    @Override
    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        ICopycatBlock.super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
        super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
        return pState;
    }

    public Class<CCCopycatBlockEntity> getBlockEntityClass() {
        return CCCopycatBlockEntity.class;
    }

    public BlockEntityType<? extends CCCopycatBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.COPYCAT.get();
    }

    @Override
    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, @Nullable BlockPos toPos, @Nullable BlockState toState) {
        if (toPos == null) {
            return true;
        }
        if (CopycatWallBlock.isPole(state)) {
            return ICopycatBlock.super.isIgnoredConnectivitySide(reader, state, face, fromPos, toPos, toState);
        }
        if (toState == null) {
            toState = reader.getBlockState(toPos);
        }
        if (!toState.is((Block)this) || !state.is((Block)this)) {
            return true;
        }
        boolean isCross = true;
        for (Direction direction : Iterate.horizontalDirections) {
            if (toState.getValue(CopycatWallBlock.byDirection(direction)) != WallSide.NONE) continue;
            isCross = false;
            break;
        }
        return isCross;
    }

    @Override
    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        if (CopycatWallBlock.isPole(state)) {
            return ICopycatBlock.super.canConnectTexturesToward(reader, fromPos, toPos, state);
        }
        BlockState toState = reader.getBlockState(toPos);
        if (!toState.is((Block)this)) {
            return false;
        }
        long sideCount = Arrays.stream(Iterate.horizontalDirections).filter(s -> state.getValue(CopycatWallBlock.byDirection(s)) != WallSide.NONE).count();
        if (sideCount > 2L) {
            return false;
        }
        if (sideCount == 2L && (state.getValue((Property)NORTH_WALL) != state.getValue((Property)SOUTH_WALL) || state.getValue((Property)EAST_WALL) != state.getValue((Property)WEST_WALL))) {
            return false;
        }
        BlockPos diff = toPos.subtract((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.ZERO)) {
            return true;
        }
        Direction face = Direction.fromDelta((int)diff.getX(), (int)diff.getY(), (int)diff.getZ());
        if (face == null) {
            if (diff.distManhattan(Vec3i.ZERO) > 2) {
                return false;
            }
            if (diff.getY() == 0) {
                return false;
            }
            Direction horizontalDiff = Direction.fromAxisAndDirection((Direction.Axis)(diff.getX() == 0 ? Direction.Axis.Z : Direction.Axis.X), (Direction.AxisDirection)(diff.getX() + diff.getZ() > 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
            if (diff.getY() > 0) {
                if (state.getValue(CopycatWallBlock.byDirection(horizontalDiff)) != WallSide.TALL) {
                    return false;
                }
                if (toState.getValue(CopycatWallBlock.byDirection(horizontalDiff.getOpposite())) == WallSide.NONE) {
                    return false;
                }
            } else {
                if (state.getValue(CopycatWallBlock.byDirection(horizontalDiff)) == WallSide.NONE) {
                    return false;
                }
                if (toState.getValue(CopycatWallBlock.byDirection(horizontalDiff.getOpposite())) != WallSide.TALL) {
                    return false;
                }
            }
            return true;
        }
        if (face == Direction.DOWN || face == Direction.UP) {
            return this.canConnectVertically(state) && this.canConnectVertically(toState);
        }
        if (((Boolean)state.getValue((Property)WallBlock.UP)).booleanValue()) {
            return false;
        }
        return state.getValue(CopycatWallBlock.byDirection(face)) != WallSide.NONE;
    }

    private static boolean isPole(BlockState state) {
        return Arrays.stream(Iterate.horizontalDirections).allMatch(s -> state.getValue(CopycatWallBlock.byDirection(s)) == WallSide.NONE);
    }

    private boolean canConnectVertically(BlockState state) {
        if (!((Boolean)state.getValue((Property)WallBlock.UP)).booleanValue()) {
            return false;
        }
        for (Direction direction : Iterate.horizontalDirections) {
            WallSide side = (WallSide)state.getValue(CopycatWallBlock.byDirection(direction));
            if (side == WallSide.NONE) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public BlockState mirror(@NotNull BlockState pState, @NotNull Mirror pMirror) {
        return super.mirror(pState, pMirror);
    }

    @Override
    @NotNull
    public BlockState rotate(@NotNull BlockState pState, Rotation pRot) {
        return super.rotate(pState, pRot);
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    @Override
    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return ICopycatBlock.hidesNeighborFace(level, pos, state, neighborState, dir);
    }

    public static EnumProperty<WallSide> byDirection(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> NORTH_WALL;
            case Direction.SOUTH -> SOUTH_WALL;
            case Direction.WEST -> WEST_WALL;
            case Direction.EAST -> EAST_WALL;
            default -> throw new IllegalArgumentException("Vertical directions not supported");
        };
    }
}

