/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.util;

import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public final class RecipeUtils {
    private RecipeUtils() {
    }

    public static <C extends RecipeInput, T extends Recipe<C>> boolean isIngredientOfAny(Level level, RecipeType<T> recipeType, ItemStack itemStack) {
        List recipes = level.getRecipeManager().getAllRecipesFor(recipeType);
        return recipes.stream().map(RecipeHolder::value).map(Recipe::getIngredients).anyMatch(ingredients -> ingredients.stream().anyMatch(ingredient -> ingredient.test(itemStack)));
    }

    public static <C extends RecipeInput, T extends Recipe<C>> boolean isResultOfAny(Level level, RecipeType<T> recipeType, ItemStack itemStack) {
        List recipes = level.getRecipeManager().getAllRecipesFor(recipeType);
        return recipes.stream().map(RecipeHolder::value).map(recipe -> recipe.getResultItem((HolderLookup.Provider)level.registryAccess())).anyMatch(stack -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemStack));
    }

    public static <C extends RecipeInput, T extends Recipe<C>> boolean isRemainderOfAny(Level level, RecipeType<T> recipeType, C container, ItemStack itemStack) {
        List recipes = level.getRecipeManager().getAllRecipesFor(recipeType);
        return recipes.stream().map(RecipeHolder::value).map(recipe -> recipe.getRemainingItems(container)).anyMatch(remainingItems -> remainingItems.stream().anyMatch(item -> ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)itemStack)));
    }
}

