/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen.base;

import me.jddev0.ep.block.entity.base.EnergyStorageBlockEntity;
import me.jddev0.ep.screen.base.IEnergyStorageMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnergyStorageMenu<T extends EnergyStorageBlockEntity<?>>
extends AbstractContainerMenu
implements IEnergyStorageMenu {
    protected final T blockEntity;
    protected final Level level;
    protected final Block blockType;

    protected EnergyStorageMenu(@Nullable MenuType<?> menuType, int id, Inventory playerInventory, BlockEntity blockEntity, Block blockType) {
        this(menuType, id, playerInventory, blockEntity, blockType, 8, 84);
    }

    protected EnergyStorageMenu(@Nullable MenuType<?> menuType, int id, Inventory playerInventory, BlockEntity blockEntity, Block blockType, int playerInventoryX, int playerInventoryY) {
        super(menuType, id);
        this.blockEntity = (EnergyStorageBlockEntity)blockEntity;
        this.level = playerInventory.player.level();
        this.blockType = blockType;
        this.addPlayerInventorySlots(playerInventory, playerInventoryX, playerInventoryY);
    }

    @Override
    public int getEnergy() {
        return ((EnergyStorageBlockEntity)this.blockEntity).getEnergy();
    }

    @Override
    public int getCapacity() {
        return ((EnergyStorageBlockEntity)this.blockEntity).getCapacity();
    }

    public boolean stillValid(@NotNull Player player) {
        return EnergyStorageMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)this.blockType);
    }

    private void addPlayerInventorySlots(Inventory playerInventory, int x, int y) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, x + i * 18, y + 58));
        }
    }

    public T getBlockEntity() {
        return this.blockEntity;
    }
}

