/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen.base;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import me.jddev0.ep.api.EPAPI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public abstract class EnergizedPowerBaseContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    protected final ResourceLocation MACHINE_SPRITES_TEXTURE = EPAPI.id("textures/gui/container/sprites/machine_sprites.png");

    public EnergizedPowerBaseContainerScreen(T menu, Inventory inventory, Component titleComponent) {
        super(menu, inventory, titleComponent);
    }

    protected void renderFluidMeterContent(GuiGraphics guiGraphics, FluidStack fluidStack, int tankCapacity, int x, int y, int w, int h) {
        RenderSystem.enableBlend();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x, (float)y, 0.0f);
        this.renderFluidStack(guiGraphics, fluidStack, tankCapacity, w, h);
        guiGraphics.pose().popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void renderFluidStack(GuiGraphics guiGraphics, FluidStack fluidStack, int tankCapacity, int w, int h) {
        if (fluidStack.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation stillFluidImageId = fluidTypeExtensions.getStillTexture(fluidStack);
        if (stillFluidImageId == null) {
            stillFluidImageId = ResourceLocation.withDefaultNamespace((String)"air");
        }
        TextureAtlasSprite stillFluidSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillFluidImageId);
        int fluidColorTint = fluidTypeExtensions.getTintColor(fluidStack);
        int fluidMeterPos = tankCapacity == -1 || fluidStack.getAmount() > 0 && fluidStack.getAmount() == tankCapacity ? 0 : h - (fluidStack.getAmount() <= 0 || tankCapacity == 0 ? 0 : Math.min(fluidStack.getAmount(), tankCapacity - 1) * h / tankCapacity + 1);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)((float)(fluidColorTint >> 16 & 0xFF) / 255.0f), (float)((float)(fluidColorTint >> 8 & 0xFF) / 255.0f), (float)((float)(fluidColorTint & 0xFF) / 255.0f), (float)((float)(fluidColorTint >> 24 & 0xFF) / 255.0f));
        Matrix4f mat = guiGraphics.pose().last().pose();
        for (int yOffset = h; yOffset > fluidMeterPos; yOffset -= 16) {
            for (int xOffset = 0; xOffset < w; xOffset += 16) {
                int width = Math.min(w - xOffset, 16);
                int height = Math.min(yOffset - fluidMeterPos, 16);
                float u0 = stillFluidSprite.getU0();
                float u1 = stillFluidSprite.getU1();
                float v0 = stillFluidSprite.getV0();
                float v1 = stillFluidSprite.getV1();
                u1 -= (float)(16 - width) / 16.0f * (u1 - u0);
                v0 -= (float)(16 - height) / 16.0f * (v0 - v1);
                Tesselator tesselator = Tesselator.getInstance();
                BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                bufferBuilder.addVertex(mat, (float)xOffset, (float)yOffset, 0.0f).setUv(u0, v1);
                bufferBuilder.addVertex(mat, (float)(xOffset + width), (float)yOffset, 0.0f).setUv(u1, v1);
                bufferBuilder.addVertex(mat, (float)(xOffset + width), (float)(yOffset - height), 0.0f).setUv(u1, v0);
                bufferBuilder.addVertex(mat, (float)xOffset, (float)(yOffset - height), 0.0f).setUv(u0, v0);
                BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            }
        }
    }
}

