/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.entity.TimeControllerBlockEntity;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SetTimeFromTimeControllerC2SPacket;
import me.jddev0.ep.screen.TimeControllerMenu;
import me.jddev0.ep.screen.base.EnergyStorageContainerScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TimeControllerScreen
extends EnergyStorageContainerScreen<TimeControllerMenu> {
    public TimeControllerScreen(TimeControllerMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, EPAPI.id("textures/gui/container/time_controller.png"));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            boolean clicked = false;
            if (this.isHovering(34, 34, 18, 18, mouseX, mouseY)) {
                ModMessages.sendToServer(new SetTimeFromTimeControllerC2SPacket(((TimeControllerBlockEntity)((TimeControllerMenu)this.menu).getBlockEntity()).getBlockPos(), 1000));
                clicked = true;
            } else if (this.isHovering(70, 34, 18, 18, mouseX, mouseY)) {
                ModMessages.sendToServer(new SetTimeFromTimeControllerC2SPacket(((TimeControllerBlockEntity)((TimeControllerMenu)this.menu).getBlockEntity()).getBlockPos(), 6000));
                clicked = true;
            } else if (this.isHovering(106, 34, 18, 18, mouseX, mouseY)) {
                ModMessages.sendToServer(new SetTimeFromTimeControllerC2SPacket(((TimeControllerBlockEntity)((TimeControllerMenu)this.menu).getBlockEntity()).getBlockPos(), 13000));
                clicked = true;
            } else if (this.isHovering(142, 34, 18, 18, mouseX, mouseY)) {
                ModMessages.sendToServer(new SetTimeFromTimeControllerC2SPacket(((TimeControllerBlockEntity)((TimeControllerMenu)this.menu).getBlockEntity()).getBlockPos(), 18000));
                clicked = true;
            }
            if (clicked) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderButtons(guiGraphics, x, y, mouseX, mouseY);
        this.renderInfoText(guiGraphics, x, y);
    }

    private void renderButtons(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.isHovering(34, 34, 18, 18, mouseX, mouseY)) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 34, y + 34, 20, 211, 18, 18);
        } else if (this.isHovering(70, 34, 18, 18, mouseX, mouseY)) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 70, y + 34, 20, 229, 18, 18);
        } else if (this.isHovering(106, 34, 18, 18, mouseX, mouseY)) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 106, y + 34, 38, 211, 18, 18);
        } else if (this.isHovering(142, 34, 18, 18, mouseX, mouseY)) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 142, y + 34, 38, 229, 18, 18);
        }
    }

    private void renderInfoText(GuiGraphics guiGraphics, int x, int y) {
        MutableComponent component = ((TimeControllerMenu)this.menu).getEnergy() < TimeControllerBlockEntity.CAPACITY ? Component.translatable((String)"tooltip.energizedpower.not_enough_energy.txt").withStyle(ChatFormatting.RED) : Component.translatable((String)"tooltip.energizedpower.ready.txt").withStyle(ChatFormatting.DARK_GREEN);
        int componentWidth = this.font.width((FormattedText)component);
        guiGraphics.drawString(this.font, (Component)component, (int)((float)(x + 34) + (float)(126 - componentWidth) * 0.5f), y + 58, 0, false);
    }

    @Override
    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isHovering(34, 34, 18, 18, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.time_controller.btn.day"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        } else if (this.isHovering(70, 34, 18, 18, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.time_controller.btn.noon"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        } else if (this.isHovering(106, 34, 18, 18, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.time_controller.btn.night"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        } else if (this.isHovering(142, 34, 18, 18, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.time_controller.btn.midnight"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

