/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.recipe.StoneSolidifierRecipe;
import me.jddev0.ep.screen.StoneSolidifierMenu;
import me.jddev0.ep.screen.base.SelectableRecipeMachineContainerScreen;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StoneSolidifierScreen
extends SelectableRecipeMachineContainerScreen<StoneSolidifierRecipe, StoneSolidifierMenu> {
    public StoneSolidifierScreen(StoneSolidifierMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, "tooltip.energizedpower.recipe.energy_required_to_finish.txt", EPAPI.id("textures/gui/container/stone_solidifier.png"), EPAPI.id("textures/gui/container/upgrade_view/1_speed_1_energy_efficiency_1_energy_capacity.png"));
        this.recipeSelectorPosX = 98;
    }

    @Override
    protected ItemStack getRecipeIcon(RecipeHolder<StoneSolidifierRecipe> currentRecipe) {
        return ((StoneSolidifierRecipe)currentRecipe.value()).getOutput();
    }

    @Override
    protected void renderCurrentRecipeTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, RecipeHolder<StoneSolidifierRecipe> currentRecipe) {
        ItemStack output = ((StoneSolidifierRecipe)currentRecipe.value()).getOutput();
        if (!output.isEmpty()) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.count_with_item.txt", (Object[])new Object[]{output.getCount(), output.getHoverName()}));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        for (int i = 0; i < 2; ++i) {
            this.renderFluidMeterContent(guiGraphics, ((StoneSolidifierMenu)this.menu).getFluid(i), ((StoneSolidifierMenu)this.menu).getTankCapacity(i), x + (i == 0 ? 44 : 152), y + 17, 16, 52);
            this.renderFluidMeterOverlay(i, guiGraphics, x, y);
        }
        this.renderProgressArrows(guiGraphics, x, y);
    }

    private void renderFluidMeterOverlay(int tank, GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + (tank == 0 ? 44 : 152), y + 17, 16, 0, 16, 52);
    }

    private void renderProgressArrows(GuiGraphics guiGraphics, int x, int y) {
        if (((StoneSolidifierMenu)this.menu).isCraftingActive()) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 69, y + 45, 72, 58, ((StoneSolidifierMenu)this.menu).getScaledProgressArrowSize(), 14);
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 143 - ((StoneSolidifierMenu)this.menu).getScaledProgressArrowSize(), y + 45, 92 - ((StoneSolidifierMenu)this.menu).getScaledProgressArrowSize(), 72, ((StoneSolidifierMenu)this.menu).getScaledProgressArrowSize(), 14);
        }
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        for (int i = 0; i < 2; ++i) {
            if (!this.isHovering(i == 0 ? 44 : 152, 17, 16, 52, mouseX, mouseY)) continue;
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((StoneSolidifierMenu)this.menu).getFluid(i).isEmpty();
            int fluidAmount = fluidEmpty ? 0 : ((StoneSolidifierMenu)this.menu).getFluid(i).getAmount();
            MutableComponent tooltipComponent = Component.translatable((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(((StoneSolidifierMenu)this.menu).getTankCapacity(i))});
            if (!fluidEmpty) {
                tooltipComponent = Component.translatable((String)((StoneSolidifierMenu)this.menu).getFluid(i).getDescriptionId()).append(" ").append((Component)tooltipComponent);
            }
            components.add(tooltipComponent);
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

