/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import me.jddev0.ep.inventory.data.SimpleEnergyValueContainerData;
import me.jddev0.ep.screen.EPMenuTypes;
import me.jddev0.ep.screen.base.IEnergyStorageMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MinecartAdvancedBatteryBoxMenu
extends AbstractContainerMenu
implements IEnergyStorageMenu {
    private final Container container;
    private final Level level;
    private final SimpleEnergyValueContainerData energyData = new SimpleEnergyValueContainerData();
    private final SimpleEnergyValueContainerData capacityData = new SimpleEnergyValueContainerData();

    public MinecartAdvancedBatteryBoxMenu(int id, Inventory inv, FriendlyByteBuf buffer) {
        this(id, inv, (Container)new SimpleContainer(0), null);
    }

    public MinecartAdvancedBatteryBoxMenu(int id, Inventory inv, Container container, ContainerData data) {
        super(EPMenuTypes.MINECART_ADVANCED_BATTERY_BOX_MENU.get(), id);
        this.container = container;
        this.level = inv.player.level();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        if (data == null) {
            this.addDataSlots(this.energyData);
            this.addDataSlots(this.capacityData);
        } else {
            this.addDataSlots(data);
        }
    }

    @Override
    public int getEnergy() {
        return this.energyData.getValue();
    }

    @Override
    public int getCapacity() {
        return this.capacityData.getValue();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

