/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.entity.FluidTransposerBlockEntity;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SetCheckboxC2SPacket;
import me.jddev0.ep.screen.FluidTransposerMenu;
import me.jddev0.ep.screen.base.ConfigurableUpgradableEnergyStorageContainerScreen;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FluidTransposerScreen
extends ConfigurableUpgradableEnergyStorageContainerScreen<FluidTransposerMenu> {
    public FluidTransposerScreen(FluidTransposerMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, "tooltip.energizedpower.recipe.energy_required_to_finish.txt", EPAPI.id("textures/gui/container/fluid_transposer.png"), EPAPI.id("textures/gui/container/upgrade_view/1_speed_1_energy_efficiency_1_energy_capacity.png"));
    }

    @Override
    protected boolean mouseClickedNormalView(double mouseX, double mouseY, int mouseButton) {
        if (super.mouseClickedNormalView(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 0 && this.isHovering(114, 47, 20, 20, mouseX, mouseY)) {
            ModMessages.sendToServer(new SetCheckboxC2SPacket(((FluidTransposerBlockEntity)((FluidTransposerMenu)this.menu).getBlockEntity()).getBlockPos(), 0, ((FluidTransposerMenu)this.menu).getMode() == FluidTransposerBlockEntity.Mode.EMPTYING));
            return true;
        }
        return false;
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderFluidMeterContent(guiGraphics, ((FluidTransposerMenu)this.menu).getFluid(), ((FluidTransposerMenu)this.menu).getTankCapacity(), x + 152, y + 17, 16, 52);
        this.renderFluidMeterOverlay(guiGraphics, x, y);
        this.renderButtons(guiGraphics, x, y, mouseX, mouseY);
        this.renderProgressArrow(guiGraphics, x, y);
    }

    private void renderFluidMeterOverlay(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 152, y + 17, 16, 0, 16, 52);
    }

    private void renderButtons(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.isHovering(114, 47, 20, 20, mouseX, mouseY)) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 114, y + 47, 0, 211, 20, 20);
        }
        ItemStack output = new ItemStack((ItemLike)(((FluidTransposerMenu)this.menu).getMode() == FluidTransposerBlockEntity.Mode.EMPTYING ? Items.BUCKET : Items.WATER_BUCKET));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        guiGraphics.renderItem(output, x + 116, y + 49, 116 + 49 * this.imageWidth);
        guiGraphics.pose().popPose();
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        int arrowPosY = ((FluidTransposerMenu)this.menu).getMode() == FluidTransposerBlockEntity.Mode.EMPTYING ? 58 : 72;
        guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 114, y + 19, 52, arrowPosY, 20, 14);
        if (((FluidTransposerMenu)this.menu).isCraftingActive()) {
            if (((FluidTransposerMenu)this.menu).getMode() == FluidTransposerBlockEntity.Mode.EMPTYING) {
                guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 114, y + 19, 72, arrowPosY, ((FluidTransposerMenu)this.menu).getScaledProgressArrowSize(), 14);
            } else {
                guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 134 - ((FluidTransposerMenu)this.menu).getScaledProgressArrowSize(), y + 19, 92 - ((FluidTransposerMenu)this.menu).getScaledProgressArrowSize(), arrowPosY, ((FluidTransposerMenu)this.menu).getScaledProgressArrowSize(), 14);
            }
        }
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ArrayList<MutableComponent> components;
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        if (this.isHovering(152, 17, 16, 52, mouseX, mouseY)) {
            components = new ArrayList<MutableComponent>(2);
            boolean fluidEmpty = ((FluidTransposerMenu)this.menu).getFluid().isEmpty();
            int fluidAmount = fluidEmpty ? 0 : ((FluidTransposerMenu)this.menu).getFluid().getAmount();
            MutableComponent tooltipComponent = Component.translatable((String)"tooltip.energizedpower.fluid_meter.content_amount.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(fluidAmount), FluidUtils.getFluidAmountWithPrefix(((FluidTransposerMenu)this.menu).getTankCapacity())});
            if (!fluidEmpty) {
                tooltipComponent = Component.translatable((String)((FluidTransposerMenu)this.menu).getFluid().getDescriptionId()).append(" ").append((Component)tooltipComponent);
            }
            components.add(tooltipComponent);
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
        if (this.isHovering(114, 47, 20, 20, mouseX, mouseY)) {
            components = new ArrayList(2);
            components.add(Component.translatable((String)("tooltip.energizedpower.fluid_transposer.mode." + ((FluidTransposerMenu)this.menu).getMode().getSerializedName())));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

