/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.PopEnergizedPowerBookFromLecternC2SPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnergizedPowerBookScreen
extends Screen {
    public static final ResourceLocation TEXTURE = EPAPI.id("textures/gui/book/energized_power_book.png");
    public static final ResourceLocation FRONT_COVER = EPAPI.id("textures/gui/book/front_cover.png");
    public static final ResourceLocation BACK_COVER = EPAPI.id("textures/gui/book/back_cover.png");
    public static final ResourceLocation ENERGIZED_COPPER_INGOT = EPAPI.id("textures/item/energized_copper_ingot.png");
    public static final int IMAGE_CYCLE_DELAY = ModConfigs.CLIENT_ENERGIZED_POWER_BOOK_IMAGE_CYCLE_DELAY.getValue();
    private static final int MAX_CHARS_PER_LINE = 148;
    private static final int MAX_LINES = 19;
    private static List<PageContent> pages = new ArrayList<PageContent>();
    private int currentTick;
    private PageButton forwardButton;
    private PageButton backButton;
    private final LecternBlockEntity lecternBlockEntity;
    private ResourceLocation openOnPageForBlock;
    private List<FormattedPageContent> formattedPages;
    private int currentPage;
    private Component currentPageNumberOutput = CommonComponents.EMPTY;
    private boolean isCurrentPageCached;

    public static void setPages(List<PageContent> pages) {
        EnergizedPowerBookScreen.pages = new ArrayList<PageContent>(pages);
    }

    public EnergizedPowerBookScreen() {
        this(null, null);
    }

    public EnergizedPowerBookScreen(ResourceLocation openOnPageForBlock) {
        this(null, openOnPageForBlock);
    }

    public EnergizedPowerBookScreen(LecternBlockEntity lecternBlockEntity) {
        this(lecternBlockEntity, null);
    }

    public EnergizedPowerBookScreen(LecternBlockEntity lecternBlockEntity, ResourceLocation openOnPageForBlock) {
        super(GameNarrator.NO_TITLE);
        this.lecternBlockEntity = lecternBlockEntity;
        this.openOnPageForBlock = openOnPageForBlock;
    }

    protected void init() {
        this.createMenuControls();
        this.createPageControlButtons();
        ArrayList<FormattedPageContent> formattedPages = new ArrayList<FormattedPageContent>();
        formattedPages.add(new FormattedPageContent(EPAPI.id("front_cover"), null, this.font.split((FormattedText)Component.translatable((String)"book.energizedpower.front.cover.text").withStyle(ChatFormatting.GRAY), 148), null, null));
        for (PageContent pageContent : pages) {
            ArrayList<FormattedCharSequence> formattedPageComponents;
            ResourceLocation pageId = pageContent.getPageId();
            Component chapterTitleComponent = pageContent.getChapterTitleComponent();
            ResourceLocation[] imageResourceLocations = pageContent.getImageResourceLocations();
            ResourceLocation[] blockResourceLocations = pageContent.getBlockResourceLocations();
            List<Object> list = formattedPageComponents = pageContent.getPageComponent() == null ? new ArrayList<FormattedCharSequence>(0) : this.font.split((FormattedText)pageContent.getPageComponent(), 148);
            if (chapterTitleComponent != null) {
                formattedPages.add(new FormattedPageContent(pageId, chapterTitleComponent, formattedPageComponents, imageResourceLocations, blockResourceLocations));
                continue;
            }
            int maxLineCountFirstPage = 19 - (imageResourceLocations != null || blockResourceLocations != null ? 7 : 0);
            formattedPages.add(new FormattedPageContent(pageId, chapterTitleComponent, formattedPageComponents.subList(0, Math.min(maxLineCountFirstPage, formattedPageComponents.size())), imageResourceLocations, blockResourceLocations));
            int i = maxLineCountFirstPage;
            int splitPageCount = 2;
            while (i < formattedPageComponents.size()) {
                ResourceLocation tmpPageId = ResourceLocation.fromNamespaceAndPath((String)pageId.getNamespace(), (String)(pageId.getPath() + "/tmp_page_" + splitPageCount));
                formattedPages.add(new FormattedPageContent(tmpPageId, null, formattedPageComponents.subList(i, Math.min(i + 19, formattedPageComponents.size())), null, null));
                i += 19;
                ++splitPageCount;
            }
        }
        formattedPages.add(new FormattedPageContent(EPAPI.id("back_cover"), null, new ArrayList<FormattedCharSequence>(0), null, null));
        this.formattedPages = new ArrayList<FormattedPageContent>(formattedPages);
        this.updateButtonVisibility();
        if (this.openOnPageForBlock != null) {
            block2: for (int i = 0; i < formattedPages.size(); ++i) {
                ResourceLocation[] blockResourceLocations = ((FormattedPageContent)formattedPages.get(i)).getBlockResourceLocations();
                if (blockResourceLocations == null) continue;
                for (ResourceLocation block : blockResourceLocations) {
                    if (!block.equals((Object)this.openOnPageForBlock)) continue;
                    this.setPage(i);
                    break block2;
                }
            }
            this.openOnPageForBlock = null;
        }
    }

    private void createMenuControls() {
        boolean showTakeButton = this.lecternBlockEntity != null && this.minecraft.player.mayBuild();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).bounds(this.width / 2 - 116, 232, showTakeButton ? 116 : 236, 20).build());
        if (showTakeButton) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"lectern.take_book"), button -> {
                ModMessages.sendToServer(new PopEnergizedPowerBookFromLecternC2SPacket(this.lecternBlockEntity.getBlockPos()));
                this.onClose();
            }).bounds(this.width / 2 + 2, 232, 116, 20).build());
        }
    }

    private void createPageControlButtons() {
        int startX = (this.width - 226) / 2;
        this.forwardButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(startX + 150, 193, true, button -> this.pageForward(), true));
        this.backButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(startX + 43, 193, false, button -> this.pageBack(), true));
        this.updateButtonVisibility();
    }

    private int getPageCount() {
        return this.formattedPages == null ? 0 : this.formattedPages.size();
    }

    private void pageForward() {
        if (this.currentPage < this.getPageCount() - 1) {
            ++this.currentPage;
            this.isCurrentPageCached = false;
        }
        this.updateButtonVisibility();
    }

    private void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.isCurrentPageCached = false;
        }
        this.updateButtonVisibility();
    }

    private boolean setPage(int page) {
        if (page < 0 || page >= this.getPageCount() || page == this.currentPage) {
            return false;
        }
        this.currentPage = page;
        this.isCurrentPageCached = false;
        this.updateButtonVisibility();
        return true;
    }

    private void updateButtonVisibility() {
        this.forwardButton.visible = this.currentPage < this.getPageCount() - 1;
        this.backButton.visible = this.currentPage > 0;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        int oldCurrentPage = this.currentPage;
        return switch (keyCode) {
            case 266 -> {
                this.backButton.onPress();
                if (this.currentPage != oldCurrentPage) {
                    this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
                }
                yield true;
            }
            case 267 -> {
                this.forwardButton.onPress();
                if (this.currentPage != oldCurrentPage) {
                    this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
                }
                yield true;
            }
            default -> false;
        };
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        Style style;
        if (mouseButton == 0 && (style = this.getComponentStyleAt(mouseX, mouseY)) != null && this.handleComponentClicked(style)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleComponentClicked(Style style) {
        ClickEvent clickEvent = style.getClickEvent();
        if (clickEvent == null || this.formattedPages == null) {
            return false;
        }
        if (clickEvent.getAction() == ClickEvent.Action.CHANGE_PAGE) {
            int oldCurrentPage = this.currentPage;
            try {
                boolean bl = this.setPage(Integer.parseInt(clickEvent.getValue()));
                return bl;
            }
            catch (NumberFormatException e) {
                int i;
                String pageIdString = clickEvent.getValue();
                ResourceLocation pageId = ResourceLocation.tryParse((String)pageIdString);
                if (pageId == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean containsKeyFlag = false;
                for (i = 0; i < this.formattedPages.size(); ++i) {
                    if (!this.formattedPages.get(i).getPageId().equals((Object)pageId)) continue;
                    containsKeyFlag = true;
                    break;
                }
                if (!containsKeyFlag) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.setPage(i);
                return bl;
            }
            finally {
                if (this.currentPage != oldCurrentPage) {
                    this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
                }
            }
        }
        boolean flag = super.handleComponentClicked(style);
        if (flag && clickEvent.getAction() == ClickEvent.Action.RUN_COMMAND) {
            this.onClose();
        }
        return flag;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.renderBackground(guiGraphics, mouseX, mouseY, delta);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.formattedPages == null) {
            return;
        }
        int startX = (this.width - 226) / 2;
        if (this.currentPage == 0) {
            guiGraphics.blit(FRONT_COVER, startX, 2, 0, 0, 226, 230);
        } else if (this.currentPage == this.getPageCount() - 1) {
            guiGraphics.blit(BACK_COVER, startX, 2, 0, 0, 226, 230);
        } else {
            guiGraphics.blit(TEXTURE, startX, 2, 0, 0, 226, 230);
        }
        if (!this.isCurrentPageCached) {
            this.currentPageNumberOutput = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage, Math.max(this.getPageCount() - 1, 1)});
            this.isCurrentPageCached = true;
        }
        int textWidth = this.font.width((FormattedText)this.currentPageNumberOutput);
        guiGraphics.drawString(this.font, this.currentPageNumberOutput, (int)((float)(this.width - textWidth) / 2.0f), 222, -1, false);
        if (this.currentPage == 0) {
            this.renderFrontCover(guiGraphics);
            return;
        }
        if (this.currentPage == this.getPageCount() - 1) {
            this.renderImageCentered(guiGraphics, ENERGIZED_COPPER_INGOT, -1);
            return;
        }
        int yOffset = 0;
        ResourceLocation[] images = this.formattedPages.get(this.currentPage).getImageResourceLocations();
        ResourceLocation[] blocks = this.formattedPages.get(this.currentPage).getBlockResourceLocations();
        Component chapterTitleComponent = this.formattedPages.get(this.currentPage).getChapterTitleComponent();
        if (chapterTitleComponent != null) {
            float f;
            float scaleFactor = 1.5f;
            float f2 = 230.0f / scaleFactor;
            Objects.requireNonNull(this.font);
            float f3 = f2 - 9.0f;
            if (this.formattedPages.get(this.currentPage).getPageFormattedTexts().isEmpty()) {
                f = 0.0f;
            } else {
                int n = this.formattedPages.get(this.currentPage).getPageFormattedTexts().size() + 1;
                Objects.requireNonNull(this.font);
                f = (float)(n * 9) / scaleFactor;
            }
            yOffset = (int)((f3 - f) * 0.5f);
            if (images != null) {
                yOffset = (int)((float)yOffset - 30.0f / scaleFactor);
            }
            if (blocks != null) {
                yOffset = (int)((float)yOffset - 30.0f / scaleFactor);
            }
            guiGraphics.pose().scale(scaleFactor, scaleFactor, 1.0f);
            guiGraphics.drawString(this.font, chapterTitleComponent, (int)(((float)this.width / scaleFactor - (float)this.font.width((FormattedText)chapterTitleComponent)) * 0.5f), yOffset, 0, false);
            guiGraphics.pose().scale(1.0f / scaleFactor, 1.0f / scaleFactor, 1.0f);
            yOffset = (int)((float)yOffset * scaleFactor);
        }
        if (images != null) {
            this.renderImageCentered(guiGraphics, images[this.currentTick / IMAGE_CYCLE_DELAY % images.length], yOffset + 15);
            yOffset += 60;
        }
        if (blocks != null) {
            this.renderBlockCentered(guiGraphics, blocks[this.currentTick / IMAGE_CYCLE_DELAY % blocks.length], yOffset + 15);
            yOffset += 60;
        }
        if (!this.formattedPages.get(this.currentPage).getPageFormattedTexts().isEmpty()) {
            for (int i = 0; i < this.formattedPages.get(this.currentPage).getPageFormattedTexts().size(); ++i) {
                FormattedCharSequence formattedCharSequence = this.formattedPages.get(this.currentPage).getPageFormattedTexts().get(i);
                float x = chapterTitleComponent == null ? (float)startX + 36.0f : (float)(this.width - this.font.width(formattedCharSequence)) * 0.5f;
                guiGraphics.drawString(this.font, formattedCharSequence, (int)x, 20 + yOffset + 9 * i, 0, false);
            }
            Style style = this.getComponentStyleAt(mouseX, mouseY);
            if (style != null) {
                guiGraphics.renderComponentHoverEffect(this.font, style, mouseX, mouseY);
            }
        }
    }

    private void renderFrontCover(GuiGraphics guiGraphics) {
        int startX = (this.width - 226) / 2;
        float scaleFactor = 1.35f;
        MutableComponent component = Component.literal((String)"Energized Power").withStyle(ChatFormatting.GOLD);
        int textWidth = this.font.width((FormattedText)component);
        guiGraphics.pose().scale(scaleFactor, scaleFactor, 1.0f);
        guiGraphics.drawString(this.font, (Component)component, (int)(((float)this.width / scaleFactor - (float)textWidth) * 0.5f), (int)(30.0f / scaleFactor), 0, false);
        guiGraphics.pose().scale(1.0f / scaleFactor, 1.0f / scaleFactor, 1.0f);
        component = Component.translatable((String)"book.byAuthor", (Object[])new Object[]{"JDDev0"}).withStyle(ChatFormatting.GOLD);
        textWidth = this.font.width((FormattedText)component);
        guiGraphics.drawString(this.font, (Component)component, (int)((float)(this.width - textWidth) * 0.5f), 147, 0, false);
        for (int i = 0; i < this.formattedPages.get(this.currentPage).getPageFormattedTexts().size(); ++i) {
            FormattedCharSequence formattedCharSequence = this.formattedPages.get(this.currentPage).getPageFormattedTexts().get(i);
            guiGraphics.drawString(this.font, formattedCharSequence, startX + 36, 120 + 9 * i, 0, false);
        }
        this.renderImageCentered(guiGraphics, ENERGIZED_COPPER_INGOT, 48);
    }

    private void renderImageCentered(GuiGraphics guiGraphics, ResourceLocation image, int y) {
        float scaleFactor = 0.25f;
        if (y == -1) {
            y = (int)((230.0f - 256.0f * scaleFactor) * 0.5f) + 2;
        }
        guiGraphics.pose().scale(scaleFactor, scaleFactor, 1.0f);
        guiGraphics.blit(image, (int)(((float)this.width / scaleFactor - 256.0f) * 0.5f), (int)((float)y / scaleFactor), 0, 0, 256, 256);
        guiGraphics.pose().scale(1.0f / scaleFactor, 1.0f / scaleFactor, 1.0f);
    }

    private void renderBlockCentered(GuiGraphics guiGraphics, ResourceLocation blockResourceLocation, int y) {
        if (y == -1) {
            y = 85;
        }
        Block block = (Block)BuiltInRegistries.BLOCK.get(blockResourceLocation);
        ItemStack itemStack = new ItemStack((ItemLike)block);
        ItemRenderer itemRenderer = this.minecraft.getItemRenderer();
        TextureManager textureManager = this.minecraft.getTextureManager();
        BakedModel bakedModel = itemRenderer.getModel(itemStack, null, null, 0);
        textureManager.getTexture(InventoryMenu.BLOCK_ATLAS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)((int)((float)this.width * 0.5f)), (float)y + 32.0f, 50.0f);
        guiGraphics.pose().scale(64.0f, -64.0f, 1.0f);
        MultiBufferSource.BufferSource bufferSource = this.minecraft.renderBuffers().bufferSource();
        Lighting.setupForEntityInInventory();
        itemRenderer.render(itemStack, ItemDisplayContext.GUI, false, guiGraphics.pose(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
        bufferSource.endBatch();
        RenderSystem.enableDepthTest();
        guiGraphics.pose().popPose();
    }

    private Style getComponentStyleAt(double x, double y) {
        if (this.formattedPages == null || this.formattedPages.get(this.currentPage).getPageFormattedTexts().isEmpty()) {
            return null;
        }
        int componentX = Mth.floor((double)(x - (double)(this.width - 226) * 0.5 - 36.0));
        int componentY = Mth.floor((double)(y - 20.0));
        if (this.currentPage > 0 && this.currentPage < this.getPageCount() - 1) {
            ResourceLocation[] images = this.formattedPages.get(this.currentPage).getImageResourceLocations();
            ResourceLocation[] blocks = this.formattedPages.get(this.currentPage).getBlockResourceLocations();
            Component chapterTitleComponent = this.formattedPages.get(this.currentPage).getChapterTitleComponent();
            if (chapterTitleComponent != null) {
                float f;
                float scaleFactor = 1.5f;
                float f2 = 230.0f / scaleFactor;
                Objects.requireNonNull(this.font);
                float f3 = f2 - 9.0f;
                if (this.formattedPages.get(this.currentPage).getPageFormattedTexts().isEmpty()) {
                    f = 0.0f;
                } else {
                    int n = this.formattedPages.get(this.currentPage).getPageFormattedTexts().size() + 1;
                    Objects.requireNonNull(this.font);
                    f = (float)(n * 9) / scaleFactor;
                }
                componentY = -((int)((f3 - f) * 0.5f));
                if (images != null) {
                    componentY = (int)((float)componentY + 30.0f / scaleFactor);
                }
                if (blocks != null) {
                    componentY = (int)((float)componentY + 30.0f / scaleFactor);
                }
                componentY = (int)((float)componentY * scaleFactor);
                componentY += Mth.floor((double)(y - 20.0));
            }
            if (images != null) {
                componentY -= 60;
            }
            if (blocks != null) {
                componentY -= 60;
            }
            if (chapterTitleComponent != null) {
                int componentIndex = componentY / 9;
                if (componentIndex < 0 || componentIndex >= this.formattedPages.get(this.currentPage).getPageFormattedTexts().size()) {
                    return null;
                }
                FormattedCharSequence formattedCharSequence = this.formattedPages.get(this.currentPage).getPageFormattedTexts().get(componentIndex);
                componentX = Mth.floor((double)(x - (double)((float)(this.width - this.font.width(formattedCharSequence)) * 0.5f)));
            }
        }
        if (componentX < 0 || componentY < 0) {
            return null;
        }
        int componentCount = this.formattedPages.get(this.currentPage).getPageFormattedTexts().size();
        if (componentX > 178 || componentY >= 9 * componentCount + componentCount) {
            return null;
        }
        int componentIndex = componentY / 9;
        if (componentIndex >= this.formattedPages.get(this.currentPage).getPageFormattedTexts().size()) {
            return null;
        }
        return this.minecraft.font.getSplitter().componentStyleAtWidth(this.formattedPages.get(this.currentPage).getPageFormattedTexts().get(componentIndex), componentX);
    }

    public boolean isPauseScreen() {
        return this.lecternBlockEntity == null;
    }

    public void tick() {
        ++this.currentTick;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class FormattedPageContent {
        private final ResourceLocation pageId;
        private final Component chapterTitleComponent;
        private final List<FormattedCharSequence> pageFormattedTexts;
        private final ResourceLocation[] imageResourceLocations;
        private final ResourceLocation[] blockResourceLocations;

        public FormattedPageContent(ResourceLocation pageId, Component chapterTitleComponent, List<FormattedCharSequence> pageFormattedTexts, ResourceLocation[] imageResourceLocations, ResourceLocation[] blockResourceLocations) {
            this.pageId = pageId;
            this.chapterTitleComponent = chapterTitleComponent;
            this.pageFormattedTexts = pageFormattedTexts;
            this.imageResourceLocations = imageResourceLocations;
            this.blockResourceLocations = blockResourceLocations;
        }

        public ResourceLocation getPageId() {
            return this.pageId;
        }

        public Component getChapterTitleComponent() {
            return this.chapterTitleComponent;
        }

        public List<FormattedCharSequence> getPageFormattedTexts() {
            return this.pageFormattedTexts;
        }

        public ResourceLocation[] getImageResourceLocations() {
            return this.imageResourceLocations;
        }

        public ResourceLocation[] getBlockResourceLocations() {
            return this.blockResourceLocations;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class PageContent {
        private final ResourceLocation pageId;
        private final Component chapterTitleComponent;
        private final Component pageComponent;
        private final ResourceLocation[] imageResourceLocations;
        private final ResourceLocation[] blockResourceLocations;

        public PageContent(ResourceLocation pageId, Component chapterTitleComponent, Component pageComponent, ResourceLocation[] imageResourceLocations, ResourceLocation[] blockResourceLocations) {
            this.pageId = pageId;
            this.chapterTitleComponent = chapterTitleComponent;
            this.pageComponent = pageComponent;
            this.imageResourceLocations = imageResourceLocations;
            this.blockResourceLocations = blockResourceLocations;
        }

        public ResourceLocation getPageId() {
            return this.pageId;
        }

        public Component getChapterTitleComponent() {
            return this.chapterTitleComponent;
        }

        public Component getPageComponent() {
            return this.pageComponent;
        }

        public ResourceLocation[] getImageResourceLocations() {
            return this.imageResourceLocations;
        }

        public ResourceLocation[] getBlockResourceLocations() {
            return this.blockResourceLocations;
        }
    }
}

