/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SetCheckboxC2SPacket;
import me.jddev0.ep.screen.CreativeBatteryBoxMenu;
import me.jddev0.ep.screen.base.EnergizedPowerBaseContainerScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreativeBatteryBoxScreen
extends EnergizedPowerBaseContainerScreen<CreativeBatteryBoxMenu> {
    private final ResourceLocation TEXTURE = EPAPI.id("textures/gui/container/creative_battery_box.png");

    public CreativeBatteryBoxScreen(CreativeBatteryBoxMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            boolean clicked = false;
            if (this.isHovering(10, 28, 11, 11, mouseX, mouseY)) {
                ModMessages.sendToServer(new SetCheckboxC2SPacket(((CreativeBatteryBoxMenu)this.menu).getBlockEntity().getBlockPos(), 0, !((CreativeBatteryBoxMenu)this.menu).isEnergyProduction()));
                clicked = true;
            } else if (this.isHovering(10, 46, 11, 11, mouseX, mouseY)) {
                ModMessages.sendToServer(new SetCheckboxC2SPacket(((CreativeBatteryBoxMenu)this.menu).getBlockEntity().getBlockPos(), 1, !((CreativeBatteryBoxMenu)this.menu).isEnergyConsumption()));
                clicked = true;
            }
            if (clicked) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(this.TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderCheckboxes(guiGraphics, x, y, mouseX, mouseY);
        this.renderCheckboxLabels(guiGraphics, x, y, mouseX, mouseY);
    }

    private void renderCheckboxes(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (((CreativeBatteryBoxMenu)this.menu).isEnergyProduction()) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 10, y + 28, 0, 139, 11, 11);
        }
        if (((CreativeBatteryBoxMenu)this.menu).isEnergyConsumption()) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 10, y + 46, 0, 139, 11, 11);
        }
    }

    private void renderCheckboxLabels(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"tooltip.energizedpower.creative_battery_box.cbx.energy_production"), x + 25, y + 30, 0, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"tooltip.energizedpower.creative_battery_box.cbx.energy_consumption"), x + 25, y + 48, 0, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.isHovering(10, 28, 11, 11, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.creative_battery_box.cbx.energy_production"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        } else if (this.isHovering(10, 46, 11, 11, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.creative_battery_box.cbx.energy_consumption"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

