/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.screen;

import java.util.ArrayList;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.entity.AutoCrafterBlockEntity;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.CycleAutoCrafterRecipeOutputC2SPacket;
import me.jddev0.ep.networking.packet.SetCheckboxC2SPacket;
import me.jddev0.ep.screen.AutoCrafterMenu;
import me.jddev0.ep.screen.base.ConfigurableUpgradableEnergyStorageContainerScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AutoCrafterScreen
extends ConfigurableUpgradableEnergyStorageContainerScreen<AutoCrafterMenu> {
    public AutoCrafterScreen(AutoCrafterMenu menu, Inventory inventory, Component component) {
        super(menu, inventory, component, "tooltip.energizedpower.recipe.energy_required_to_finish.txt", EPAPI.id("textures/gui/container/auto_crafter.png"), EPAPI.id("textures/gui/container/upgrade_view/auto_crafter.png"));
        this.imageHeight = 206;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    @Override
    protected boolean mouseClickedNormalView(double mouseX, double mouseY, int mouseButton) {
        if (super.mouseClickedNormalView(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (mouseButton == 0) {
            if (this.isHovering(158, 16, 11, 11, mouseX, mouseY)) {
                ModMessages.sendToServer(new SetCheckboxC2SPacket(((AutoCrafterBlockEntity)((AutoCrafterMenu)this.menu).getBlockEntity()).getBlockPos(), 0, !((AutoCrafterMenu)this.menu).isIgnoreNBT()));
                return true;
            }
            if (this.isHovering(158, 38, 11, 11, mouseX, mouseY)) {
                ModMessages.sendToServer(new SetCheckboxC2SPacket(((AutoCrafterBlockEntity)((AutoCrafterMenu)this.menu).getBlockEntity()).getBlockPos(), 1, !((AutoCrafterMenu)this.menu).isSecondaryExtractMode()));
                return true;
            }
            if (this.isHovering(158, 59, 11, 11, mouseX, mouseY)) {
                ModMessages.sendToServer(new SetCheckboxC2SPacket(((AutoCrafterBlockEntity)((AutoCrafterMenu)this.menu).getBlockEntity()).getBlockPos(), 2, !((AutoCrafterMenu)this.menu).isAllowOutputOverflow()));
                return true;
            }
            if (this.isHovering(126, 16, 12, 12, mouseX, mouseY)) {
                ModMessages.sendToServer(new CycleAutoCrafterRecipeOutputC2SPacket(((AutoCrafterBlockEntity)((AutoCrafterMenu)this.menu).getBlockEntity()).getBlockPos()));
                return true;
            }
        }
        return false;
    }

    @Override
    protected void renderBgNormalView(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBgNormalView(guiGraphics, partialTick, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderProgressArrow(guiGraphics, x, y);
        this.renderCheckboxes(guiGraphics, x, y, mouseX, mouseY);
    }

    private void renderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((AutoCrafterMenu)this.menu).isCraftingActive()) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 89, y + 34, 0, 58, ((AutoCrafterMenu)this.menu).getScaledProgressArrowSize(), 17);
        }
    }

    private void renderCheckboxes(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (((AutoCrafterMenu)this.menu).isIgnoreNBT()) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 158, y + 16, 0, 139, 11, 11);
        }
        if (((AutoCrafterMenu)this.menu).isSecondaryExtractMode()) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 158, y + 38, 22, 139, 11, 11);
        } else {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 158, y + 38, 11, 139, 11, 11);
        }
        if (((AutoCrafterMenu)this.menu).isAllowOutputOverflow()) {
            guiGraphics.blit(this.MACHINE_SPRITES_TEXTURE, x + 158, y + 59, 0.0f, 139.0f, 11, 11, 256, 256);
        }
    }

    @Override
    protected void renderTooltipNormalView(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltipNormalView(guiGraphics, mouseX, mouseY);
        if (this.isHovering(158, 16, 11, 11, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.auto_crafter.cbx.ignore_nbt"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        } else if (this.isHovering(158, 38, 11, 11, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)("tooltip.energizedpower.auto_crafter.cbx.extract_mode." + (((AutoCrafterMenu)this.menu).isSecondaryExtractMode() ? "2" : "1"))));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        } else if (this.isHovering(158, 59, 11, 11, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.auto_crafter.cbx.allow_output_overflow"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        } else if (this.isHovering(126, 16, 12, 12, mouseX, mouseY)) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>(2);
            components.add(Component.translatable((String)"tooltip.energizedpower.auto_crafter.cycle_through_recipes"));
            guiGraphics.renderTooltip(this.font, components, Optional.empty(), mouseX, mouseY);
        }
    }
}

