/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class StoneLiquefierRecipe
implements Recipe<RecipeInput> {
    private final Ingredient input;
    private final FluidStack output;

    public StoneLiquefierRecipe(Ingredient input, FluidStack output) {
        this.input = input;
        this.output = output;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }

    public boolean matches(RecipeInput container, Level level) {
        if (level.isClientSide) {
            return false;
        }
        return this.input.test(container.getItem(0));
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add(0, (Object)this.input);
        return ingredients;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)EPBlocks.STONE_LIQUEFIER.get());
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<? extends Recipe<RecipeInput>> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<? extends Recipe<RecipeInput>> getType() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<StoneLiquefierRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("stone_liquefier");
        private final MapCodec<StoneLiquefierRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)FluidStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.output)).apply((Applicative)instance, StoneLiquefierRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, StoneLiquefierRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<StoneLiquefierRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, StoneLiquefierRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static StoneLiquefierRecipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            FluidStack output = (FluidStack)FluidStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            return new StoneLiquefierRecipe(input, output);
        }

        private static void write(RegistryFriendlyByteBuf buffer, StoneLiquefierRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            FluidStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }
    }

    public static final class Type
    implements RecipeType<StoneLiquefierRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "stone_liquefier";

        private Type() {
        }
    }
}

