/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.codec.CodecFix;
import me.jddev0.ep.item.EPItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SawmillRecipe
implements Recipe<RecipeInput> {
    private final ItemStack output;
    private final ItemStack secondaryOutput;
    private final Ingredient input;

    public SawmillRecipe(ItemStack output, Ingredient input, int sawdustAmount) {
        this(output, new ItemStack((ItemLike)EPItems.SAWDUST.get(), sawdustAmount), input);
    }

    public SawmillRecipe(ItemStack output, ItemStack secondaryOutput, Ingredient input) {
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.input = input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public boolean matches(RecipeInput container, Level level) {
        if (level.isClientSide) {
            return false;
        }
        return this.input.test(container.getItem(0));
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider registries) {
        return this.output;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.output.copy();
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add(0, (Object)this.input);
        return ingredients;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)EPBlocks.SAWMILL_ITEM.get());
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<SawmillRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("sawmill");
        private final MapCodec<SawmillRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("sawdustAmount").forGetter(recipe -> {
            if (recipe.secondaryOutput.isEmpty()) {
                return Optional.of(0);
            }
            return ItemStack.isSameItemSameComponents((ItemStack)recipe.secondaryOutput, (ItemStack)new ItemStack((ItemLike)EPItems.SAWDUST.get())) ? Optional.of(recipe.secondaryOutput.getCount()) : Optional.empty();
        }), (App)CodecFix.ITEM_STACK_CODEC.optionalFieldOf("secondaryOutput").forGetter(recipe -> {
            if (recipe.secondaryOutput.isEmpty()) {
                return Optional.empty();
            }
            return ItemStack.isSameItemSameComponents((ItemStack)recipe.secondaryOutput, (ItemStack)new ItemStack((ItemLike)EPItems.SAWDUST.get())) ? Optional.empty() : Optional.of(recipe.secondaryOutput);
        })).apply((Applicative)instance, (output, ingredient, sawdustAmount, secondaryOutput) -> secondaryOutput.map(o -> new SawmillRecipe((ItemStack)output, (ItemStack)o, (Ingredient)ingredient)).orElseGet(() -> sawdustAmount.map(a -> new SawmillRecipe((ItemStack)output, (Ingredient)ingredient, (int)a)).orElseThrow(() -> new IllegalArgumentException("Either \"sawdustAmount\" or \"secondaryOutput\" must be present")))));
        private final StreamCodec<RegistryFriendlyByteBuf, SawmillRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<SawmillRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SawmillRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static SawmillRecipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack output = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            ItemStack secondaryOutput = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            return new SawmillRecipe(output, secondaryOutput, input);
        }

        private static void write(RegistryFriendlyByteBuf buffer, SawmillRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.secondaryOutput);
        }
    }

    public static final class Type
    implements RecipeType<SawmillRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "sawmill";

        private Type() {
        }
    }
}

