/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.codec.CodecFix;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PulverizerRecipe
implements Recipe<RecipeInput> {
    private final OutputItemStackWithPercentages output;
    private final OutputItemStackWithPercentages secondaryOutput;
    private final Ingredient input;

    public PulverizerRecipe(OutputItemStackWithPercentages output, OutputItemStackWithPercentages secondaryOutput, Ingredient input) {
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.input = input;
    }

    public OutputItemStackWithPercentages getOutput() {
        return this.output;
    }

    public OutputItemStackWithPercentages getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack[] getMaxOutputCounts(boolean advanced) {
        ItemStack[] generatedOutputs = new ItemStack[]{this.output.output.copyWithCount(advanced ? this.output.percentagesAdvanced.length : this.output.percentages.length), this.secondaryOutput.output.copyWithCount(advanced ? this.secondaryOutput.percentagesAdvanced.length : this.secondaryOutput.percentages.length)};
        return generatedOutputs;
    }

    public ItemStack[] generateOutputs(RandomSource randomSource, boolean advanced) {
        ItemStack[] generatedOutputs = new ItemStack[2];
        for (int i = 0; i < 2; ++i) {
            int count = 0;
            OutputItemStackWithPercentages output = i == 0 ? this.output : this.secondaryOutput;
            for (double percentage : advanced ? output.percentagesAdvanced : output.percentages) {
                if (!(randomSource.nextDouble() <= percentage)) continue;
                ++count;
            }
            generatedOutputs[i] = output.output.copyWithCount(count);
        }
        return generatedOutputs;
    }

    public boolean matches(RecipeInput container, Level level) {
        if (level.isClientSide) {
            return false;
        }
        return this.input.test(container.getItem(0));
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add(0, (Object)this.input);
        return ingredients;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)EPBlocks.PULVERIZER_ITEM.get());
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public record OutputItemStackWithPercentages(ItemStack output, double[] percentages, double[] percentagesAdvanced) {
        public OutputItemStackWithPercentages(ItemStack output, double percentage, double percentageAdvanced) {
            this(output, new double[]{percentage}, new double[]{percentageAdvanced});
        }

        public OutputItemStackWithPercentages(ItemStack output) {
            this(output, 1.0, 1.0);
        }

        private static Codec<double[]> createDoubleArrayCodec(final boolean atLeastOnePercentageValue) {
            return new Codec<double[]>(){
                private static final Codec<List<Double>> DOUBLE_LIST_CODEC = Codec.doubleRange((double)0.0, (double)1.0).listOf();

                public <T> DataResult<Pair<double[], T>> decode(DynamicOps<T> ops, T input) {
                    return DOUBLE_LIST_CODEC.decode(ops, input).flatMap(res -> {
                        boolean errorFlag = atLeastOnePercentageValue && ((List)res.getFirst()).stream().noneMatch(d -> (int)d.doubleValue() >= 1);
                        Pair newRes = Pair.of((Object)((List)res.getFirst()).stream().mapToDouble(Double::doubleValue).toArray(), (Object)res.getSecond());
                        if (errorFlag) {
                            return DataResult.error(() -> "The primary output must have a minimum count of at least 1 (At least one percentage value must be >= 1.0)", (Object)newRes);
                        }
                        return DataResult.success((Object)newRes);
                    });
                }

                public <T> DataResult<T> encode(double[] input, DynamicOps<T> ops, T prefix) {
                    return DOUBLE_LIST_CODEC.encode(Arrays.stream(input).boxed().toList(), ops, prefix);
                }
            };
        }

        public static Codec<OutputItemStackWithPercentages> createCodec(boolean atLeastOnePercentageValue) {
            return RecordCodecBuilder.create(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(output -> output.output), (App)OutputItemStackWithPercentages.createDoubleArrayCodec(atLeastOnePercentageValue).fieldOf("percentages").forGetter(output -> output.percentages), (App)OutputItemStackWithPercentages.createDoubleArrayCodec(atLeastOnePercentageValue).optionalFieldOf("percentagesAdvanced").forGetter(output -> Optional.of(output.percentagesAdvanced))).apply((Applicative)instance, (output, percentages, percentagesAdvanced) -> {
                if (percentagesAdvanced.isPresent()) {
                    return new OutputItemStackWithPercentages((ItemStack)output, (double[])percentages, (double[])percentagesAdvanced.get());
                }
                return new OutputItemStackWithPercentages((ItemStack)output, (double[])percentages, (double[])percentages);
            }));
        }
    }

    public static final class Serializer
    implements RecipeSerializer<PulverizerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("pulverizer");
        private final MapCodec<PulverizerRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)OutputItemStackWithPercentages.createCodec(true).fieldOf("output").forGetter(recipe -> recipe.output), (App)OutputItemStackWithPercentages.createCodec(false).optionalFieldOf("secondaryOutput").forGetter(recipe -> {
            if (recipe.secondaryOutput.output.isEmpty() || recipe.secondaryOutput.percentages.length == 0) {
                return Optional.empty();
            }
            return Optional.of(recipe.secondaryOutput);
        }), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.input)).apply((Applicative)instance, (output, secondaryOutput, input) -> new PulverizerRecipe((OutputItemStackWithPercentages)output, secondaryOutput.orElse(new OutputItemStackWithPercentages(ItemStack.EMPTY, new double[0], new double[0])), (Ingredient)input)));
        private final StreamCodec<RegistryFriendlyByteBuf, PulverizerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<PulverizerRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PulverizerRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static PulverizerRecipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[2];
            for (int i = 0; i < 2; ++i) {
                ItemStack output = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
                int percentageCount = buffer.readInt();
                double[] percentages = new double[percentageCount];
                for (int j = 0; j < percentageCount; ++j) {
                    percentages[j] = buffer.readDouble();
                }
                int percentageAdvancedCount = buffer.readInt();
                double[] percentagesAdvanced = new double[percentageAdvancedCount];
                for (int j = 0; j < percentageAdvancedCount; ++j) {
                    percentagesAdvanced[j] = buffer.readDouble();
                }
                outputs[i] = new OutputItemStackWithPercentages(output, percentages, percentagesAdvanced);
            }
            return new PulverizerRecipe(outputs[0], outputs[1], input);
        }

        private static void write(RegistryFriendlyByteBuf buffer, PulverizerRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            for (int i = 0; i < 2; ++i) {
                OutputItemStackWithPercentages output = i == 0 ? recipe.output : recipe.secondaryOutput;
                ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)output.output);
                buffer.writeInt(output.percentages.length);
                for (double percentage : output.percentages) {
                    buffer.writeDouble(percentage);
                }
                buffer.writeInt(output.percentagesAdvanced.length);
                for (double percentage : output.percentagesAdvanced) {
                    buffer.writeDouble(percentage);
                }
            }
        }
    }

    public static final class Type
    implements RecipeType<PulverizerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "pulverizer";

        private Type() {
        }
    }
}

