/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FiltrationPlantRecipe
implements Recipe<RecipeInput> {
    private final OutputItemStackWithPercentages output;
    private final OutputItemStackWithPercentages secondaryOutput;
    private final ResourceLocation icon;

    public FiltrationPlantRecipe(OutputItemStackWithPercentages output, OutputItemStackWithPercentages secondaryOutput, ResourceLocation icon) {
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.icon = icon;
    }

    public OutputItemStackWithPercentages getOutput() {
        return this.output;
    }

    public OutputItemStackWithPercentages getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public ItemStack[] getMaxOutputCounts() {
        ItemStack[] generatedOutputs = new ItemStack[]{this.output.output().copyWithCount(this.output.percentages().length), this.secondaryOutput.output().copyWithCount(this.secondaryOutput.percentages().length)};
        return generatedOutputs;
    }

    public ItemStack[] generateOutputs(RandomSource randomSource) {
        ItemStack[] generatedOutputs = new ItemStack[2];
        for (int i = 0; i < 2; ++i) {
            int count = 0;
            OutputItemStackWithPercentages output = i == 0 ? this.output : this.secondaryOutput;
            for (double percentage : output.percentages()) {
                if (!(randomSource.nextDouble() <= percentage)) continue;
                ++count;
            }
            generatedOutputs[i] = output.output().copyWithCount(count);
        }
        return generatedOutputs;
    }

    public boolean matches(RecipeInput container, Level level) {
        return false;
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)EPBlocks.FILTRATION_PLANT.get());
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<FiltrationPlantRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("filtration_plant");
        private final MapCodec<FiltrationPlantRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)OutputItemStackWithPercentages.CODEC_NONEMPTY.fieldOf("output").forGetter(recipe -> recipe.output), (App)OutputItemStackWithPercentages.CODEC_NONEMPTY.optionalFieldOf("secondaryOutput").forGetter(recipe -> Optional.ofNullable(recipe.secondaryOutput.isEmpty() ? null : recipe.secondaryOutput)), (App)ResourceLocation.CODEC.fieldOf("icon").forGetter(recipe -> recipe.icon)).apply((Applicative)instance, (output, secondaryOutput, icon) -> new FiltrationPlantRecipe((OutputItemStackWithPercentages)output, secondaryOutput.orElse(OutputItemStackWithPercentages.EMPTY), (ResourceLocation)icon)));
        private final StreamCodec<RegistryFriendlyByteBuf, FiltrationPlantRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<FiltrationPlantRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FiltrationPlantRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static FiltrationPlantRecipe read(RegistryFriendlyByteBuf buffer) {
            OutputItemStackWithPercentages[] outputs = new OutputItemStackWithPercentages[2];
            for (int i = 0; i < 2; ++i) {
                outputs[i] = (OutputItemStackWithPercentages)OutputItemStackWithPercentages.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            }
            ResourceLocation icon = buffer.readResourceLocation();
            return new FiltrationPlantRecipe(outputs[0], outputs[1], icon);
        }

        private static void write(RegistryFriendlyByteBuf buffer, FiltrationPlantRecipe recipe) {
            for (int i = 0; i < 2; ++i) {
                OutputItemStackWithPercentages output = i == 0 ? recipe.output : recipe.secondaryOutput;
                OutputItemStackWithPercentages.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)output);
            }
            buffer.writeResourceLocation(recipe.icon);
        }
    }

    public static final class Type
    implements RecipeType<FiltrationPlantRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "filtration_plant";

        private Type() {
        }
    }
}

