/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CrystalGrowthChamberRecipe
implements Recipe<RecipeInput> {
    private final OutputItemStackWithPercentages output;
    private final Ingredient input;
    private final int inputCount;
    private final int ticks;

    public CrystalGrowthChamberRecipe(OutputItemStackWithPercentages output, Ingredient input, int inputCount, int ticks) {
        this.output = output;
        this.input = input;
        this.inputCount = inputCount;
        this.ticks = ticks;
    }

    public OutputItemStackWithPercentages getOutput() {
        return this.output;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public int getTicks() {
        return this.ticks;
    }

    public ItemStack getMaxOutputCount() {
        return this.output.output().copyWithCount(this.output.percentages().length);
    }

    public ItemStack generateOutput(RandomSource randomSource) {
        int count = 0;
        for (double percentage : this.output.percentages()) {
            if (!(randomSource.nextDouble() <= percentage)) continue;
            ++count;
        }
        return this.output.output().copyWithCount(count);
    }

    public boolean matches(RecipeInput container, Level level) {
        if (level.isClientSide) {
            return false;
        }
        return this.input.test(container.getItem(0)) && container.getItem(0).getCount() >= this.inputCount;
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)EPBlocks.CRYSTAL_GROWTH_CHAMBER_ITEM.get());
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<CrystalGrowthChamberRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("crystal_growth_chamber");
        private final MapCodec<CrystalGrowthChamberRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)OutputItemStackWithPercentages.CODEC_NONEMPTY.fieldOf("output").forGetter(recipe -> recipe.output), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("inputCount", (Object)1).forGetter(recipe -> recipe.inputCount), (App)ExtraCodecs.POSITIVE_INT.fieldOf("ticks").forGetter(recipe -> recipe.ticks)).apply((Applicative)instance, CrystalGrowthChamberRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, CrystalGrowthChamberRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<CrystalGrowthChamberRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CrystalGrowthChamberRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static CrystalGrowthChamberRecipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int inputCount = buffer.readInt();
            int ticks = buffer.readInt();
            OutputItemStackWithPercentages output = (OutputItemStackWithPercentages)OutputItemStackWithPercentages.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            return new CrystalGrowthChamberRecipe(output, input, inputCount, ticks);
        }

        private static void write(RegistryFriendlyByteBuf buffer, CrystalGrowthChamberRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            buffer.writeInt(recipe.inputCount);
            buffer.writeInt(recipe.ticks);
            OutputItemStackWithPercentages.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }
    }

    public static final class Type
    implements RecipeType<CrystalGrowthChamberRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "crystal_growth_chamber";

        private Type() {
        }
    }
}

