/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.codec.ArrayCodec;
import me.jddev0.ep.codec.CodecFix;
import me.jddev0.ep.recipe.IngredientWithCount;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AlloyFurnaceRecipe
implements Recipe<RecipeInput> {
    private final ItemStack output;
    private final OutputItemStackWithPercentages secondaryOutput;
    private final IngredientWithCount[] inputs;
    private final int ticks;

    public AlloyFurnaceRecipe(ItemStack output, OutputItemStackWithPercentages secondaryOutput, IngredientWithCount[] inputs, int ticks) {
        this.output = output;
        this.secondaryOutput = secondaryOutput;
        this.inputs = inputs;
        this.ticks = ticks;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public OutputItemStackWithPercentages getSecondaryOutput() {
        return this.secondaryOutput;
    }

    public IngredientWithCount[] getInputs() {
        return this.inputs;
    }

    public int getTicks() {
        return this.ticks;
    }

    public ItemStack[] getMaxOutputCounts() {
        ItemStack[] generatedOutputs = new ItemStack[]{this.output.copyWithCount(this.output.getCount()), this.secondaryOutput.output().copyWithCount(this.secondaryOutput.percentages().length)};
        return generatedOutputs;
    }

    public ItemStack[] generateOutputs(RandomSource randomSource) {
        ItemStack[] generatedOutputs = new ItemStack[2];
        generatedOutputs[0] = this.output.copyWithCount(this.output.getCount());
        int count = 0;
        for (double percentage : this.secondaryOutput.percentages()) {
            if (!(randomSource.nextDouble() <= percentage)) continue;
            ++count;
        }
        generatedOutputs[1] = this.secondaryOutput.output().copyWithCount(count);
        return generatedOutputs;
    }

    public boolean matches(RecipeInput container, Level level) {
        if (level.isClientSide) {
            return false;
        }
        boolean[] usedIndices = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            usedIndices[i] = container.getItem(i).isEmpty();
        }
        int len = Math.min(this.inputs.length, 3);
        for (int i = 0; i < len; ++i) {
            IngredientWithCount input = this.inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 3; ++j) {
                if (usedIndices[j]) continue;
                ItemStack item = container.getItem(j);
                if (indexMinCount != -1 && item.getCount() >= minCount || !input.input().test(item) || item.getCount() < input.count()) continue;
                indexMinCount = j;
                minCount = item.getCount();
            }
            if (indexMinCount == -1) {
                return false;
            }
            usedIndices[indexMinCount] = true;
        }
        for (boolean usedIndex : usedIndices) {
            if (usedIndex) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)EPBlocks.ALLOY_FURNACE_ITEM.get());
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static final class Serializer
    implements RecipeSerializer<AlloyFurnaceRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = EPAPI.id("alloy_furnace");
        private final MapCodec<AlloyFurnaceRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)OutputItemStackWithPercentages.CODEC_NONEMPTY.optionalFieldOf("secondaryOutput").forGetter(recipe -> Optional.ofNullable(recipe.secondaryOutput.isEmpty() ? null : recipe.secondaryOutput)), (App)new ArrayCodec<IngredientWithCount>(IngredientWithCount.CODEC_NONEMPTY, IngredientWithCount[]::new).fieldOf("inputs").forGetter(recipe -> recipe.inputs), (App)ExtraCodecs.POSITIVE_INT.fieldOf("ticks").forGetter(recipe -> recipe.ticks)).apply((Applicative)instance, (output, secondaryOutput, inputs, ticks) -> new AlloyFurnaceRecipe((ItemStack)output, secondaryOutput.orElse(OutputItemStackWithPercentages.EMPTY), (IngredientWithCount[])inputs, (int)ticks)));
        private final StreamCodec<RegistryFriendlyByteBuf, AlloyFurnaceRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        private Serializer() {
        }

        public MapCodec<AlloyFurnaceRecipe> codec() {
            return this.CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AlloyFurnaceRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static AlloyFurnaceRecipe read(RegistryFriendlyByteBuf buffer) {
            int len = buffer.readInt();
            IngredientWithCount[] inputs = new IngredientWithCount[len];
            for (int i = 0; i < len; ++i) {
                inputs[i] = (IngredientWithCount)IngredientWithCount.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            }
            int ticks = buffer.readInt();
            ItemStack output = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            OutputItemStackWithPercentages secondaryOutput = (OutputItemStackWithPercentages)OutputItemStackWithPercentages.OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            return new AlloyFurnaceRecipe(output, secondaryOutput, inputs, ticks);
        }

        private static void write(RegistryFriendlyByteBuf buffer, AlloyFurnaceRecipe recipe) {
            buffer.writeInt(recipe.inputs.length);
            for (int i = 0; i < recipe.inputs.length; ++i) {
                IngredientWithCount.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.inputs[i]);
            }
            buffer.writeInt(recipe.ticks);
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
            OutputItemStackWithPercentages.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)recipe.secondaryOutput);
        }
    }

    public static final class Type
    implements RecipeType<AlloyFurnaceRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "alloy_furnace";

        private Type() {
        }
    }
}

