/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.entity.PressMoldMakerBlockEntity;
import me.jddev0.ep.recipe.PressMoldMakerRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public final class SyncPressMoldMakerRecipeListS2CPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SyncPressMoldMakerRecipeListS2CPacket> ID = new CustomPacketPayload.Type(EPAPI.id("sync_press_mold_maker_recipe_list"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncPressMoldMakerRecipeListS2CPacket> STREAM_CODEC = StreamCodec.ofMember(SyncPressMoldMakerRecipeListS2CPacket::write, SyncPressMoldMakerRecipeListS2CPacket::new);
    private final BlockPos pos;
    private final List<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>> recipeList;

    public SyncPressMoldMakerRecipeListS2CPacket(BlockPos pos, List<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>> recipeList) {
        this.pos = pos;
        this.recipeList = recipeList;
    }

    public SyncPressMoldMakerRecipeListS2CPacket(RegistryFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        int size = buffer.readInt();
        this.recipeList = IntStream.range(0, size).mapToObj(i -> Pair.of((Object)new RecipeHolder(buffer.readResourceLocation(), (Recipe)((PressMoldMakerRecipe)PressMoldMakerRecipe.Serializer.INSTANCE.streamCodec().decode((Object)buffer))), (Object)buffer.readBoolean())).collect(Collectors.toList());
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeInt(this.recipeList.size());
        this.recipeList.forEach(entry -> {
            buffer.writeResourceLocation(((RecipeHolder)entry.getFirst()).id());
            PressMoldMakerRecipe.Serializer.INSTANCE.streamCodec().encode((Object)buffer, (Object)((PressMoldMakerRecipe)((RecipeHolder)entry.getFirst()).value()));
            buffer.writeBoolean(((Boolean)entry.getSecond()).booleanValue());
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static void handle(SyncPressMoldMakerRecipeListS2CPacket data, IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockEntity blockEntity = context.player().level().getBlockEntity(data.pos);
            if (blockEntity instanceof PressMoldMakerBlockEntity) {
                PressMoldMakerBlockEntity pressMoldMakerBlockEntity = (PressMoldMakerBlockEntity)blockEntity;
                pressMoldMakerBlockEntity.setRecipeList(data.recipeList);
            }
        });
    }
}

