/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.recipe.CurrentRecipePacketUpdate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SyncCurrentRecipeS2CPacket<R extends Recipe<?>>
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<SyncCurrentRecipeS2CPacket<?>> ID = new CustomPacketPayload.Type(EPAPI.id("sync_current_recipe"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncCurrentRecipeS2CPacket<?>> STREAM_CODEC = StreamCodec.ofMember(SyncCurrentRecipeS2CPacket::write, SyncCurrentRecipeS2CPacket::new);
    private final BlockPos pos;
    private final RecipeSerializer<R> recipeSerializer;
    private final RecipeHolder<R> currentRecipe;

    public SyncCurrentRecipeS2CPacket(BlockPos pos, RecipeSerializer<R> recipeSerializerId, @Nullable RecipeHolder<R> currentRecipe) {
        this.pos = pos;
        this.recipeSerializer = recipeSerializerId;
        this.currentRecipe = currentRecipe;
    }

    public SyncCurrentRecipeS2CPacket(RegistryFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        ResourceLocation recipeSerializerId = buffer.readResourceLocation();
        this.recipeSerializer = (RecipeSerializer)BuiltInRegistries.RECIPE_SERIALIZER.get(recipeSerializerId);
        if (this.recipeSerializer == null) {
            throw new IllegalArgumentException("Recipe Serializer \"" + String.valueOf(recipeSerializerId) + "\" does not exist!");
        }
        this.currentRecipe = buffer.readBoolean() ? new RecipeHolder(buffer.readResourceLocation(), (Recipe)this.recipeSerializer.streamCodec().decode((Object)buffer)) : null;
    }

    public void write(RegistryFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        ResourceLocation recipeSerializerId = BuiltInRegistries.RECIPE_SERIALIZER.getKey(this.recipeSerializer);
        if (recipeSerializerId == null) {
            throw new IllegalArgumentException("The recipe serializer \"" + this.recipeSerializer.getClass().getCanonicalName() + "\" is not registered!");
        }
        buffer.writeResourceLocation(recipeSerializerId);
        if (this.currentRecipe == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.writeResourceLocation(this.currentRecipe.id());
            this.recipeSerializer.streamCodec().encode((Object)buffer, (Object)this.currentRecipe.value());
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static <R extends Recipe<?>> void handle(SyncCurrentRecipeS2CPacket<R> data, IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockEntity blockEntity = context.player().level().getBlockEntity(data.pos);
            if (blockEntity instanceof CurrentRecipePacketUpdate) {
                CurrentRecipePacketUpdate currentRecipePacketUpdate = (CurrentRecipePacketUpdate)blockEntity;
                currentRecipePacketUpdate.setCurrentRecipe(data.currentRecipe);
            }
        });
    }
}

