/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.List;
import me.jddev0.ep.block.WrenchConfigurable;
import me.jddev0.ep.component.EPDataComponentTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class WrenchItem
extends Item {
    public WrenchItem(Item.Properties props) {
        super(props);
    }

    public static Direction getCurrentFace(ItemStack itemStack) {
        return (Direction)itemStack.getOrDefault(EPDataComponentTypes.CURRENT_FACE, (Object)Direction.DOWN);
    }

    public static void cycleCurrentFace(ItemStack itemStack, ServerPlayer player) {
        int diff = player.isShiftKeyDown() ? -1 : 1;
        Direction currentFace = WrenchItem.getCurrentFace(itemStack);
        currentFace = Direction.values()[(currentFace.ordinal() + diff + Direction.values().length) % Direction.values().length];
        itemStack.set(EPDataComponentTypes.CURRENT_FACE, (Object)currentFace);
        player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.wrench.select_face", (Object[])new Object[]{Component.translatable((String)("tooltip.energizedpower.direction." + currentFace.getSerializedName())).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})}).withStyle(ChatFormatting.GRAY)));
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Player player = useOnContext.getPlayer();
        BlockPos blockPos = useOnContext.getClickedPos();
        BlockState state = level.getBlockState(blockPos);
        Block block = state.getBlock();
        if (!(block instanceof WrenchConfigurable)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.wrench.not_configurable").withStyle(ChatFormatting.RED)));
            }
            return InteractionResult.SUCCESS;
        }
        WrenchConfigurable wrenchConfigurableBlock = (WrenchConfigurable)block;
        ItemStack itemStack = useOnContext.getItemInHand();
        Direction currentFace = WrenchItem.getCurrentFace(itemStack);
        return wrenchConfigurableBlock.onUseWrench(useOnContext, currentFace, player != null && player.isShiftKeyDown());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)itemStack);
        }
        WrenchItem.cycleCurrentFace(itemStack, (ServerPlayer)player);
        return InteractionResultHolder.success((Object)itemStack);
    }

    public float getDestroySpeed(ItemStack itemStack, BlockState blockState) {
        return 1000.0f;
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos blockPos, Player player) {
        if (level.isClientSide || !(player instanceof ServerPlayer)) {
            return false;
        }
        ItemStack itemStack = player.getMainHandItem();
        if (itemStack.has(EPDataComponentTypes.ACTION_COOLDOWN)) {
            return false;
        }
        WrenchItem.cycleCurrentFace(itemStack, (ServerPlayer)player);
        itemStack.set(EPDataComponentTypes.ACTION_COOLDOWN, (Object)5);
        return false;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        Direction currentFace = WrenchItem.getCurrentFace(itemStack);
        components.add((Component)Component.translatable((String)"tooltip.energizedpower.wrench.select_face", (Object[])new Object[]{Component.translatable((String)("tooltip.energizedpower.direction." + currentFace.getSerializedName())).withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})}).withStyle(ChatFormatting.GRAY));
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.wrench.txt.shift").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
        }
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemStack, level, entity, slot, selected);
        if (level.isClientSide) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        if (itemStack.has(EPDataComponentTypes.ACTION_COOLDOWN)) {
            int attackingCycleCooldown = (Integer)itemStack.getOrDefault(EPDataComponentTypes.ACTION_COOLDOWN, (Object)0) - 1;
            if (attackingCycleCooldown <= 0) {
                itemStack.remove(EPDataComponentTypes.ACTION_COOLDOWN);
            } else {
                itemStack.set(EPDataComponentTypes.ACTION_COOLDOWN, (Object)attackingCycleCooldown);
            }
        }
    }
}

