/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.List;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.component.DimensionalPositionComponent;
import me.jddev0.ep.component.EPDataComponentTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TeleporterMatrixItem
extends Item {
    public TeleporterMatrixItem(Item.Properties props) {
        super(props);
    }

    public static boolean isLinked(ItemStack itemStack) {
        return itemStack.has(EPDataComponentTypes.DIMENSIONAL_POSITION);
    }

    public static BlockPos getBlockPos(Level level, ItemStack itemStack) {
        if (level.isClientSide) {
            return null;
        }
        if (!TeleporterMatrixItem.isLinked(itemStack)) {
            return null;
        }
        DimensionalPositionComponent dimPos = (DimensionalPositionComponent)itemStack.get(EPDataComponentTypes.DIMENSIONAL_POSITION);
        if (dimPos == null) {
            return null;
        }
        return new BlockPos(dimPos.x(), dimPos.y(), dimPos.z());
    }

    public static Level getDimension(Level level, ItemStack itemStack) {
        if (level.isClientSide || !(level instanceof ServerLevel)) {
            return null;
        }
        if (!TeleporterMatrixItem.isLinked(itemStack)) {
            return null;
        }
        DimensionalPositionComponent dimPos = (DimensionalPositionComponent)itemStack.get(EPDataComponentTypes.DIMENSIONAL_POSITION);
        if (dimPos == null) {
            return null;
        }
        ResourceKey dimensionKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimPos.dimensionId());
        return level.getServer().getLevel(dimensionKey);
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        if (level.isClientSide || !(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        Player player = useOnContext.getPlayer();
        BlockPos blockPos = useOnContext.getClickedPos();
        BlockState state = level.getBlockState(blockPos);
        ItemStack itemStack = useOnContext.getItemInHand();
        itemStack.set(EPDataComponentTypes.DIMENSIONAL_POSITION, (Object)new DimensionalPositionComponent(blockPos.getX(), blockPos.getY(), blockPos.getZ(), level.dimension().location()));
        if (state.is((Block)EPBlocks.TELEPORTER.get())) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter_matrix.set").withStyle(ChatFormatting.GREEN)));
            }
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter_matrix.set.warning").withStyle(ChatFormatting.YELLOW)));
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)itemStack);
        }
        if (itemStack.has(EPDataComponentTypes.DIMENSIONAL_POSITION)) {
            itemStack.remove(EPDataComponentTypes.DIMENSIONAL_POSITION);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"tooltip.energizedpower.teleporter_matrix.cleared").withStyle(ChatFormatting.GREEN)));
        }
        return InteractionResultHolder.success((Object)itemStack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        DimensionalPositionComponent dimPos = (DimensionalPositionComponent)itemStack.get(EPDataComponentTypes.DIMENSIONAL_POSITION);
        boolean linked = TeleporterMatrixItem.isLinked(itemStack) && dimPos != null;
        components.add((Component)Component.translatable((String)"tooltip.energizedpower.teleporter_matrix.status").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)("tooltip.energizedpower.teleporter_matrix.status." + (linked ? "linked" : "unlinked"))).withStyle(linked ? ChatFormatting.GREEN : ChatFormatting.RED)));
        if (linked) {
            components.add((Component)Component.empty());
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.teleporter_matrix.location").append((Component)Component.literal((String)(dimPos.x() + " " + dimPos.y() + " " + dimPos.z()))));
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.teleporter_matrix.dimension").append((Component)Component.literal((String)dimPos.dimensionId().toString())));
        }
        components.add((Component)Component.empty());
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.teleporter_matrix.txt.shift.1").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.teleporter_matrix.txt.shift.2").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
        }
    }

    public String getDescriptionId(ItemStack itemStack) {
        return this.getDescriptionId() + "." + (TeleporterMatrixItem.isLinked(itemStack) ? "linked" : "unlinked");
    }
}

