/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.List;
import me.jddev0.ep.block.entity.TeleporterBlockEntity;
import me.jddev0.ep.component.DimensionalPositionComponent;
import me.jddev0.ep.component.EPDataComponentTypes;
import me.jddev0.ep.component.InventoryComponent;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.item.EPItems;
import me.jddev0.ep.item.TeleporterMatrixItem;
import me.jddev0.ep.item.energy.EnergizedPowerEnergyItem;
import me.jddev0.ep.screen.InventoryTeleporterMenu;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryTeleporterItem
extends EnergizedPowerEnergyItem
implements MenuProvider {
    public static final int CAPACITY = ModConfigs.COMMON_INVENTORY_TELEPORTER_CAPACITY.getValue();
    public static final int MAX_RECEIVE = ModConfigs.COMMON_INVENTORY_TELEPORTER_TRANSFER_RATE.getValue();

    public InventoryTeleporterItem(Item.Properties props) {
        super(props, () -> new ReceiveOnlyEnergyStorage(0, CAPACITY, MAX_RECEIVE));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (interactionHand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (level.isClientSide || !(player instanceof ServerPlayer)) {
            return InteractionResultHolder.success((Object)itemStack);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (player.isShiftKeyDown()) {
            player.openMenu((MenuProvider)this);
        } else {
            InventoryTeleporterItem.teleportPlayer(itemStack, serverPlayer);
        }
        return InteractionResultHolder.success((Object)itemStack);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.energizedpower.inventory_teleporter");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new InventoryTeleporterMenu(id, inventory, (Container)InventoryTeleporterItem.getInventory(inventory.getSelected()));
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, context, components, tooltipFlag);
        SimpleContainer inventory = InventoryTeleporterItem.getInventory(itemStack);
        ItemStack teleporterMatrixItemStack = inventory.getItem(0);
        DimensionalPositionComponent dimPos = (DimensionalPositionComponent)teleporterMatrixItemStack.get(EPDataComponentTypes.DIMENSIONAL_POSITION);
        boolean linked = TeleporterMatrixItem.isLinked(teleporterMatrixItemStack) && dimPos != null;
        components.add((Component)Component.translatable((String)"tooltip.energizedpower.teleporter_matrix.status").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)("tooltip.energizedpower.teleporter_matrix.status." + (linked ? "linked" : "unlinked"))).withStyle(linked ? ChatFormatting.GREEN : ChatFormatting.RED)));
        if (linked) {
            components.add((Component)Component.empty());
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.teleporter_matrix.location").append((Component)Component.literal((String)(dimPos.x() + " " + dimPos.y() + " " + dimPos.z()))));
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.teleporter_matrix.dimension").append((Component)Component.literal((String)dimPos.dimensionId().toString())));
        }
        components.add((Component)Component.empty());
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.inventory_teleporter.txt.shift.1").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.inventory_teleporter.txt.shift.2").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
        }
    }

    public static SimpleContainer getInventory(final ItemStack itemStack) {
        InventoryComponent inventory = (InventoryComponent)itemStack.get(EPDataComponentTypes.INVENTORY);
        if (inventory != null) {
            NonNullList items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
            for (int i = 0; i < items.size() && inventory.size() > i; ++i) {
                items.set(i, (Object)inventory.get(i));
            }
            return new SimpleContainer((ItemStack[])items.toArray((Object[])new ItemStack[0])){

                public void setChanged() {
                    super.setChanged();
                    NonNullList items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
                    for (int i = 0; i < this.getContainerSize(); ++i) {
                        items.set(i, (Object)this.getItem(i));
                    }
                    itemStack.set(EPDataComponentTypes.INVENTORY, (Object)new InventoryComponent((List<ItemStack>)items));
                }

                public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
                    if (slot >= 0 && slot < this.getContainerSize()) {
                        return stack.is((Item)EPItems.TELEPORTER_MATRIX.get());
                    }
                    return super.canPlaceItem(slot, stack);
                }

                public boolean stillValid(Player player) {
                    return super.stillValid(player) && player.getInventory().getSelected() == itemStack;
                }

                public int getMaxStackSize() {
                    return 1;
                }
            };
        }
        return new SimpleContainer(1){

            public void setChanged() {
                super.setChanged();
                NonNullList items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
                for (int i = 0; i < this.getContainerSize(); ++i) {
                    items.set(i, (Object)this.getItem(i));
                }
                itemStack.set(EPDataComponentTypes.INVENTORY, (Object)new InventoryComponent((List<ItemStack>)items));
            }

            public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < this.getContainerSize()) {
                    return stack.is((Item)EPItems.TELEPORTER_MATRIX.get());
                }
                return super.canPlaceItem(slot, stack);
            }

            public boolean stillValid(Player player) {
                return super.stillValid(player) && player.getInventory().getSelected() == itemStack;
            }

            public int getMaxStackSize() {
                return 1;
            }
        };
    }

    public static void teleportPlayer(ItemStack itemStack, ServerPlayer player) {
        Level level = player.level();
        IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null) {
            return;
        }
        SimpleContainer inventory = InventoryTeleporterItem.getInventory(itemStack);
        ItemStack teleporterMatrixItemStack = inventory.getItem(0);
        TeleporterBlockEntity.teleportPlayer(player, energyStorage, () -> InventoryTeleporterItem.setEnergy(itemStack, 0), teleporterMatrixItemStack, level, null);
    }
}

