/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.component.EPDataComponentTypes;
import me.jddev0.ep.component.InventoryComponent;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.integration.curios.CuriosCompatUtils;
import me.jddev0.ep.screen.InventoryChargerMenu;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryChargerItem
extends Item
implements MenuProvider {
    public static final int SLOT_COUNT = ModConfigs.COMMON_INVENTORY_CHARGER_SLOT_COUNT.getValue();
    public static final boolean TRANSFER_RATE_LIMIT_ENABLED = ModConfigs.COMMON_INVENTORY_CHARGER_TRANSFER_RATE_LIMIT_ENABLED.getValue();
    public static final int TRANSFER_RATE_LIMIT = ModConfigs.COMMON_INVENTORY_CHARGER_TRANSFER_RATE_LIMIT.getValue();

    public InventoryChargerItem(Item.Properties props) {
        super(props);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (interactionHand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)itemStack);
        }
        player.openMenu((MenuProvider)this);
        return InteractionResultHolder.success((Object)itemStack);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.energizedpower.inventory_charger");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new InventoryChargerMenu(id, inventory, (Container)InventoryChargerItem.getInventory(inventory.getSelected()));
    }

    public boolean isBarVisible(ItemStack stack) {
        SimpleContainer inventory = InventoryChargerItem.getInventory(stack);
        return InventoryChargerItem.getCapacity((Container)inventory) > 0;
    }

    public int getBarWidth(ItemStack stack) {
        SimpleContainer inventory = InventoryChargerItem.getInventory(stack);
        return Math.round((float)InventoryChargerItem.getEnergy((Container)inventory) * 13.0f / (float)InventoryChargerItem.getCapacity((Container)inventory));
    }

    public int getBarColor(ItemStack stack) {
        SimpleContainer inventory = InventoryChargerItem.getInventory(stack);
        float f = Math.max(0.0f, (float)InventoryChargerItem.getEnergy((Container)inventory) / (float)InventoryChargerItem.getCapacity((Container)inventory));
        return Mth.hsvToRgb((float)(f * 0.33f), (float)1.0f, (float)1.0f);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        SimpleContainer inventory = InventoryChargerItem.getInventory(itemStack);
        int energy = InventoryChargerItem.getEnergy((Container)inventory);
        int capacity = InventoryChargerItem.getCapacity((Container)inventory);
        int maxTransfer = InventoryChargerItem.getMaxTransfer((Container)inventory);
        components.add((Component)Component.translatable((String)"tooltip.energizedpower.energy_meter.content.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(energy), EnergyUtils.getEnergyWithPrefix(capacity)}).withStyle(ChatFormatting.GRAY));
        components.add((Component)Component.translatable((String)"tooltip.energizedpower.transfer_rate.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(maxTransfer)}).withStyle(ChatFormatting.GRAY));
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.inventory_charger.txt.shift.1").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
        }
    }

    private int addConsumerEnergyItem(List<IEnergyStorage> consumerItems, List<Integer> consumerEnergyValues, ItemStack itemStack, ItemStack testItemStack, Container inventoryChargerInventory) {
        IEnergyStorage energyStorage = (IEnergyStorage)testItemStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage == null || !energyStorage.canReceive()) {
            return 0;
        }
        int received = energyStorage.receiveEnergy(InventoryChargerItem.getMaxTransfer(inventoryChargerInventory), true);
        if (received <= 0) {
            return 0;
        }
        consumerItems.add(energyStorage);
        consumerEnergyValues.add(received);
        return received;
    }

    private void distributeEnergy(ItemStack itemStack, Level level, Inventory inventory, int slot, boolean selected) {
        SimpleContainer inventoryChargerInventory = InventoryChargerItem.getInventory(itemStack);
        ArrayList<IEnergyStorage> consumerItems = new ArrayList<IEnergyStorage>();
        ArrayList<Integer> consumerEnergyValues = new ArrayList<Integer>();
        int consumptionSum = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            if (i == slot) continue;
            ItemStack testItemStack = inventory.getItem(i);
            consumptionSum += this.addConsumerEnergyItem(consumerItems, consumerEnergyValues, itemStack, testItemStack, (Container)inventoryChargerInventory);
        }
        List<ItemStack> curiosItemStacks = CuriosCompatUtils.getCuriosItemStacks(inventory);
        for (ItemStack testItemStack : curiosItemStacks) {
            consumptionSum += this.addConsumerEnergyItem(consumerItems, consumerEnergyValues, itemStack, testItemStack, (Container)inventoryChargerInventory);
        }
        ArrayList<Integer> consumerEnergyDistributed = new ArrayList<Integer>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0);
        }
        int consumptionLeft = Math.min(InventoryChargerItem.getMaxTransfer((Container)inventoryChargerInventory), consumptionSum);
        this.extractEnergyFromBatteries(consumptionLeft, (Container)inventoryChargerInventory);
        int divisor = consumerItems.size();
        block3: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                int consumptionDistributed = (Integer)consumerEnergyDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)consumerEnergyValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block3;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            int energy = (Integer)consumerEnergyDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)consumerItems.get(i)).receiveEnergy(energy, false);
        }
        inventoryChargerInventory.setChanged();
    }

    public void extractEnergyFromBatteries(int energyProductionLeft, Container inventory) {
        ArrayList<IEnergyStorage> energyProduction = new ArrayList<IEnergyStorage>();
        ArrayList<Integer> energyProductionValues = new ArrayList<Integer>();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            int extracted;
            ItemStack stack = inventory.getItem(i);
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null || (extracted = energyStorage.extractEnergy(energyStorage.getMaxEnergyStored(), true)) <= 0) continue;
            energyProduction.add(energyStorage);
            energyProductionValues.add(extracted);
        }
        ArrayList<Integer> energyProductionDistributed = new ArrayList<Integer>();
        for (int i = 0; i < energyProduction.size(); ++i) {
            energyProductionDistributed.add(0);
        }
        int productionLeft = energyProductionLeft;
        int divisor = energyProduction.size();
        block2: while (productionLeft > 0) {
            int productionPerProducer = productionLeft / divisor;
            if (productionPerProducer == 0) {
                divisor = Math.max(1, divisor - 1);
                productionPerProducer = productionLeft / divisor;
            }
            for (int i = 0; i < energyProductionValues.size(); ++i) {
                int productionDistributed = (Integer)energyProductionDistributed.get(i);
                int productionOfProducerLeft = (Integer)energyProductionValues.get(i) - productionDistributed;
                int productionDistributedNew = Math.min(productionPerProducer, Math.min(productionOfProducerLeft, productionLeft));
                energyProductionDistributed.set(i, productionDistributed + productionDistributedNew);
                if ((productionLeft -= productionDistributedNew) == 0) break block2;
            }
        }
        for (int i = 0; i < energyProduction.size(); ++i) {
            int energy = (Integer)energyProductionDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)energyProduction.get(i)).extractEnergy(energy, false);
        }
    }

    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemStack, level, entity, slot, selected);
        if (level.isClientSide) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Inventory inventory = player.getInventory();
        if (player.containerMenu instanceof InventoryChargerMenu) {
            return;
        }
        this.distributeEnergy(itemStack, level, inventory, slot, selected);
    }

    public static SimpleContainer getInventory(final ItemStack itemStack) {
        InventoryComponent inventory = (InventoryComponent)itemStack.get(EPDataComponentTypes.INVENTORY);
        if (inventory != null) {
            NonNullList items = NonNullList.withSize((int)SLOT_COUNT, (Object)ItemStack.EMPTY);
            for (int i = 0; i < items.size() && inventory.size() > i; ++i) {
                items.set(i, (Object)inventory.get(i));
            }
            return new SimpleContainer((ItemStack[])items.toArray((Object[])new ItemStack[0])){

                public void setChanged() {
                    super.setChanged();
                    NonNullList items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
                    for (int i = 0; i < this.getContainerSize(); ++i) {
                        items.set(i, (Object)this.getItem(i));
                    }
                    itemStack.set(EPDataComponentTypes.INVENTORY, (Object)new InventoryComponent((List<ItemStack>)items));
                }

                public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
                    if (slot >= 0 && slot < this.getContainerSize()) {
                        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                        return energyStorage != null && energyStorage.canExtract();
                    }
                    return super.canPlaceItem(slot, stack);
                }

                public boolean stillValid(Player player) {
                    return super.stillValid(player) && player.getInventory().getSelected() == itemStack;
                }

                public int getMaxStackSize() {
                    return 1;
                }
            };
        }
        return new SimpleContainer(SLOT_COUNT){

            public void setChanged() {
                super.setChanged();
                NonNullList items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
                for (int i = 0; i < this.getContainerSize(); ++i) {
                    items.set(i, (Object)this.getItem(i));
                }
                itemStack.set(EPDataComponentTypes.INVENTORY, (Object)new InventoryComponent((List<ItemStack>)items));
            }

            public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot < this.getContainerSize()) {
                    IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                    return energyStorage != null && energyStorage.canExtract();
                }
                return super.canPlaceItem(slot, stack);
            }

            public boolean stillValid(Player player) {
                return super.stillValid(player) && player.getInventory().getSelected() == itemStack;
            }

            public int getMaxStackSize() {
                return 1;
            }
        };
    }

    public static int getEnergy(Container inventory) {
        int energySum = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) continue;
            int value = energyStorage.getEnergyStored();
            if ((long)(energySum + value) != (long)energySum + (long)value) {
                return Integer.MAX_VALUE;
            }
            energySum += value;
        }
        return energySum;
    }

    public static int getCapacity(Container inventory) {
        int capacitySum = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) continue;
            int value = energyStorage.getMaxEnergyStored();
            if ((long)(capacitySum + value) != (long)capacitySum + (long)value) {
                return Integer.MAX_VALUE;
            }
            capacitySum += value;
        }
        return capacitySum;
    }

    public static int getMaxTransfer(Container inventory) {
        int maxTransferSum = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyStorage == null) continue;
            int value = energyStorage.extractEnergy(energyStorage.getMaxEnergyStored(), true);
            if ((long)(maxTransferSum + value) != (long)maxTransferSum + (long)value) {
                return Integer.MAX_VALUE;
            }
            maxTransferSum += value;
        }
        if (TRANSFER_RATE_LIMIT_ENABLED) {
            return Math.min(maxTransferSum, TRANSFER_RATE_LIMIT);
        }
        return maxTransferSum;
    }
}

