/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.ArrayList;
import java.util.List;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.item.energy.EnergizedPowerEnergyItem;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergyAnalyzerItem
extends EnergizedPowerEnergyItem {
    public static final int ENERGY_CONSUMPTION_PER_USE = ModConfigs.COMMON_ENERGY_ANALYZER_ENERGY_CONSUMPTION_PER_USE.getValue();
    public static final int ENERGY_CAPACITY = ModConfigs.COMMON_ENERGY_ANALYZER_CAPACITY.getValue();

    public EnergyAnalyzerItem(Item.Properties props) {
        super(props, () -> new ReceiveOnlyEnergyStorage(0, ENERGY_CAPACITY, ModConfigs.COMMON_ENERGY_ANALYZER_TRANSFER_RATE.getValue()));
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, context, components, tooltipFlag);
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.energy_analyzer.txt.shift.1").withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.energy_analyzer.txt.shift.2", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(ENERGY_CONSUMPTION_PER_USE)}).withStyle(ChatFormatting.GRAY));
        } else {
            components.add((Component)Component.translatable((String)"tooltip.energizedpower.shift_details.txt").withStyle(ChatFormatting.YELLOW));
        }
    }

    private void useItem(ItemStack itemStack, Player player, List<Component> lines) {
        if (EnergyAnalyzerItem.getEnergy(itemStack) >= ENERGY_CONSUMPTION_PER_USE) {
            EnergyAnalyzerItem.setEnergy(itemStack, EnergyAnalyzerItem.getEnergy(itemStack) - ENERGY_CONSUMPTION_PER_USE);
        }
        for (Component component : lines) {
            player.sendSystemMessage(component);
        }
        player.sendSystemMessage((Component)Component.empty());
    }

    private void addOutputTextForEnergyStorage(List<Component> components, @Nullable IEnergyStorage energyStorage, boolean blockFaceSpecificInformation) {
        if (energyStorage == null) {
            components.add((Component)Component.translatable((String)("txt.energizedpower.energy_analyzer.no_energy_block" + (blockFaceSpecificInformation ? "_side" : ""))).withStyle(ChatFormatting.RED));
            return;
        }
        components.add((Component)Component.translatable((String)"txt.energizedpower.energy_analyzer.energy_output", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(energyStorage.getEnergyStored()), EnergyUtils.getEnergyWithPrefix(energyStorage.getMaxEnergyStored())}).withStyle(ChatFormatting.GOLD));
        if (energyStorage.canReceive()) {
            components.add((Component)Component.translatable((String)("txt.energizedpower.energy_analyzer.energy_can_receive" + (blockFaceSpecificInformation ? "_side" : ""))).withStyle(ChatFormatting.GOLD));
        }
        if (energyStorage.canExtract()) {
            components.add((Component)Component.translatable((String)("txt.energizedpower.energy_analyzer.energy_can_extract" + (blockFaceSpecificInformation ? "_side" : ""))).withStyle(ChatFormatting.GOLD));
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext useOnContext) {
        Level level = useOnContext.getLevel();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (EnergyAnalyzerItem.getEnergy(stack) < ENERGY_CONSUMPTION_PER_USE) {
            this.useItem(stack, useOnContext.getPlayer(), List.of(Component.translatable((String)"txt.energizedpower.energy_analyzer.no_energy_left", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(ENERGY_CONSUMPTION_PER_USE)}).withStyle(ChatFormatting.RED)));
            return InteractionResult.SUCCESS;
        }
        BlockPos blockPos = useOnContext.getClickedPos();
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)level.getBlockState(blockPos).getBlock().getName().withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.AQUA}));
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        IEnergyStorage energyStorage = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, blockPos, level.getBlockState(blockPos), blockEntity, null);
        this.addOutputTextForEnergyStorage(components, energyStorage, false);
        components.add((Component)Component.translatable((String)"txt.energizedpower.energy_analyzer.output_side_information").withStyle(ChatFormatting.BLUE));
        IEnergyStorage energyStorageSided = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, blockPos, level.getBlockState(blockPos), blockEntity, (Object)useOnContext.getClickedFace());
        this.addOutputTextForEnergyStorage(components, energyStorageSided, true);
        this.useItem(stack, useOnContext.getPlayer(), components);
        return InteractionResult.SUCCESS;
    }
}

