/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.inventory;

import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class PatternSlot
extends Slot {
    private final BooleanSupplier isEnabled;

    public PatternSlot(Container container, int slot, int x, int y, BooleanSupplier isEnabled) {
        super(container, slot, x, y);
        this.isEnabled = isEnabled;
    }

    protected void onQuickCraft(ItemStack itemStack, int amount) {
    }

    public boolean mayPlace(ItemStack itemStack) {
        return false;
    }

    public boolean mayPickup(Player player) {
        return true;
    }

    public ItemStack safeInsert(ItemStack itemStack, int amount) {
        if (!this.isEnabled.getAsBoolean()) {
            return itemStack;
        }
        if (!itemStack.isEmpty()) {
            ItemStack selfItem = this.getItem();
            if (selfItem.isEmpty() || !ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)selfItem) || !ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)selfItem)) {
                this.set(itemStack.copyWithCount(1));
            } else {
                selfItem.grow(1);
                this.set(selfItem);
            }
        }
        return itemStack;
    }

    public Optional<ItemStack> tryRemove(int count, int limit, Player player) {
        if (!this.isEnabled.getAsBoolean()) {
            return Optional.empty();
        }
        ItemStack selfItem = this.getItem();
        if (!selfItem.isEmpty()) {
            selfItem.shrink(1);
            this.set(selfItem);
        }
        return Optional.empty();
    }

    public boolean isFake() {
        return true;
    }
}

